/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.Article;
import com.mypurecloud.sdk.v2.model.Faq;
import com.mypurecloud.sdk.v2.model.SuggestionCannedResponse;
import com.mypurecloud.sdk.v2.model.SuggestionContext;
import com.mypurecloud.sdk.v2.model.SuggestionKnowledgeArticle;
import com.mypurecloud.sdk.v2.model.SuggestionKnowledgeSearch;
import com.mypurecloud.sdk.v2.model.SuggestionScript;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class Suggestion
implements Serializable {
    private String id = null;
    private TypeEnum type = null;
    private Faq faq = null;
    private Article article = null;
    private Date dateCreated = null;
    private String answerRecordId = null;
    private TriggerTypeEnum triggerType = null;
    private SuggestionContext context = null;
    private StateEnum state = null;
    private SuggestionKnowledgeSearch knowledgeSearch = null;
    private SuggestionKnowledgeArticle knowledgeArticle = null;
    private SuggestionCannedResponse cannedResponse = null;
    private SuggestionScript script = null;
    private String selfUri = null;
    private AddressableEntityRef conversation = null;
    private AddressableEntityRef assistant = null;

    public Suggestion() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The type of the documents for which the suggestion is.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    @ApiModelProperty(example="null", value="The Faq from the knowledgebase that was provided as the suggestion.")
    @JsonProperty(value="faq")
    public Faq getFaq() {
        return this.faq;
    }

    @ApiModelProperty(example="null", value="The article from the knowledgebase that was provided as the suggestion.")
    @JsonProperty(value="article")
    public Article getArticle() {
        return this.article;
    }

    @ApiModelProperty(example="2020-09-25T11:57:02Z", value="Date when the suggestion was created. For example: yyyy-MM-ddTHH:mm:ss.SSZ. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="The ID of the knowledge search that provided the suggestion.")
    @JsonProperty(value="answerRecordId")
    public String getAnswerRecordId() {
        return this.answerRecordId;
    }

    @ApiModelProperty(example="null", value="The trigger type of the suggestion.")
    @JsonProperty(value="triggerType")
    public TriggerTypeEnum getTriggerType() {
        return this.triggerType;
    }

    @ApiModelProperty(example="null", value="The conversation context in which the suggestion was raised.")
    @JsonProperty(value="context")
    public SuggestionContext getContext() {
        return this.context;
    }

    @ApiModelProperty(example="null", value="The state of the suggestion.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    @ApiModelProperty(example="null", value="The suggested knowledge search result that was provided as the suggestion.")
    @JsonProperty(value="knowledgeSearch")
    public SuggestionKnowledgeSearch getKnowledgeSearch() {
        return this.knowledgeSearch;
    }

    @ApiModelProperty(example="null", value="The suggested knowledge article that was provided as the suggestion.")
    @JsonProperty(value="knowledgeArticle")
    public SuggestionKnowledgeArticle getKnowledgeArticle() {
        return this.knowledgeArticle;
    }

    @ApiModelProperty(example="null", value="The suggested canned response that was provided as the suggestion.")
    @JsonProperty(value="cannedResponse")
    public SuggestionCannedResponse getCannedResponse() {
        return this.cannedResponse;
    }

    @ApiModelProperty(example="null", value="The suggested script that was provided as the suggestion.")
    @JsonProperty(value="script")
    public SuggestionScript getScript() {
        return this.script;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    @ApiModelProperty(example="null", value="The conversation that the suggestions correspond to.")
    @JsonProperty(value="conversation")
    public AddressableEntityRef getConversation() {
        return this.conversation;
    }

    @ApiModelProperty(example="null", value="The assistant that was used to provide the suggestions.")
    @JsonProperty(value="assistant")
    public AddressableEntityRef getAssistant() {
        return this.assistant;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Suggestion suggestion = (Suggestion)o;
        return Objects.equals(this.id, suggestion.id) && Objects.equals((Object)this.type, (Object)suggestion.type) && Objects.equals(this.faq, suggestion.faq) && Objects.equals(this.article, suggestion.article) && Objects.equals(this.dateCreated, suggestion.dateCreated) && Objects.equals(this.answerRecordId, suggestion.answerRecordId) && Objects.equals((Object)this.triggerType, (Object)suggestion.triggerType) && Objects.equals(this.context, suggestion.context) && Objects.equals((Object)this.state, (Object)suggestion.state) && Objects.equals(this.knowledgeSearch, suggestion.knowledgeSearch) && Objects.equals(this.knowledgeArticle, suggestion.knowledgeArticle) && Objects.equals(this.cannedResponse, suggestion.cannedResponse) && Objects.equals(this.script, suggestion.script) && Objects.equals(this.selfUri, suggestion.selfUri) && Objects.equals(this.conversation, suggestion.conversation) && Objects.equals(this.assistant, suggestion.assistant);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.faq, this.article, this.dateCreated, this.answerRecordId, this.triggerType, this.context, this.state, this.knowledgeSearch, this.knowledgeArticle, this.cannedResponse, this.script, this.selfUri, this.conversation, this.assistant});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Suggestion {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    faq: ").append(this.toIndentedString(this.faq)).append("\n");
        sb.append("    article: ").append(this.toIndentedString(this.article)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    answerRecordId: ").append(this.toIndentedString(this.answerRecordId)).append("\n");
        sb.append("    triggerType: ").append(this.toIndentedString((Object)this.triggerType)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    knowledgeSearch: ").append(this.toIndentedString(this.knowledgeSearch)).append("\n");
        sb.append("    knowledgeArticle: ").append(this.toIndentedString(this.knowledgeArticle)).append("\n");
        sb.append("    cannedResponse: ").append(this.toIndentedString(this.cannedResponse)).append("\n");
        sb.append("    script: ").append(this.toIndentedString(this.script)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("    conversation: ").append(this.toIndentedString(this.conversation)).append("\n");
        sb.append("    assistant: ").append(this.toIndentedString(this.assistant)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        FAQ("Faq"),
        ARTICLE("Article"),
        KNOWLEDGEARTICLE("KnowledgeArticle"),
        KNOWLEDGESEARCH("KnowledgeSearch"),
        CANNEDRESPONSE("CannedResponse"),
        SCRIPT("Script");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=TriggerTypeEnumDeserializer.class)
    public static enum TriggerTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNKNOWN("Unknown"),
        FALLBACK("Fallback"),
        CONVERSATIONSTART("ConversationStart"),
        CONVERSATIONTRANSFER("ConversationTransfer"),
        CONVERSATIONEND("ConversationEnd"),
        INTENT("Intent");

        private String value;

        private TriggerTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TriggerTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TriggerTypeEnum value : TriggerTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TriggerTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SUGGESTED("Suggested"),
        ACCEPTED("Accepted"),
        DISMISSED("Dismissed"),
        FAILED("Failed"),
        RATED("Rated");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class TriggerTypeEnumDeserializer
    extends StdDeserializer<TriggerTypeEnum> {
        public TriggerTypeEnumDeserializer() {
            super(TriggerTypeEnumDeserializer.class);
        }

        public TriggerTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TriggerTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

