/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Model for a Nuance bot environment")
public class NuanceEnvironment
implements Serializable {
    private String id = null;
    private String name = null;
    private String environmentDesignation = null;
    private String executionHost = null;

    public NuanceEnvironment() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public NuanceEnvironment id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The environment ID")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public NuanceEnvironment name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The environment name")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NuanceEnvironment environmentDesignation(String environmentDesignation) {
        this.environmentDesignation = environmentDesignation;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The environment type, usually a value like SANDBOX or PRODUCTION")
    @JsonProperty(value="environmentDesignation")
    public String getEnvironmentDesignation() {
        return this.environmentDesignation;
    }

    public void setEnvironmentDesignation(String environmentDesignation) {
        this.environmentDesignation = environmentDesignation;
    }

    public NuanceEnvironment executionHost(String executionHost) {
        this.executionHost = executionHost;
        return this;
    }

    @ApiModelProperty(example="null", value="The host used to execute this bot, similar to 'api.nuance.com:443'")
    @JsonProperty(value="executionHost")
    public String getExecutionHost() {
        return this.executionHost;
    }

    public void setExecutionHost(String executionHost) {
        this.executionHost = executionHost;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NuanceEnvironment nuanceEnvironment = (NuanceEnvironment)o;
        return Objects.equals(this.id, nuanceEnvironment.id) && Objects.equals(this.name, nuanceEnvironment.name) && Objects.equals(this.environmentDesignation, nuanceEnvironment.environmentDesignation) && Objects.equals(this.executionHost, nuanceEnvironment.executionHost);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.environmentDesignation, this.executionHost);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NuanceEnvironment {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    environmentDesignation: ").append(this.toIndentedString(this.environmentDesignation)).append("\n");
        sb.append("    executionHost: ").append(this.toIndentedString(this.executionHost)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

