/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.KnowledgeExportJobFilter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class KnowledgeExportJobRequest
implements Serializable {
    private KnowledgeExportJobFilter exportFilter = null;
    private FileTypeEnum fileType = null;
    private String sourceId = null;
    private Integer jsonFileVersion = null;

    public KnowledgeExportJobRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public KnowledgeExportJobRequest exportFilter(KnowledgeExportJobFilter exportFilter) {
        this.exportFilter = exportFilter;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="What to export.")
    @JsonProperty(value="exportFilter")
    public KnowledgeExportJobFilter getExportFilter() {
        return this.exportFilter;
    }

    public void setExportFilter(KnowledgeExportJobFilter exportFilter) {
        this.exportFilter = exportFilter;
    }

    public KnowledgeExportJobRequest fileType(FileTypeEnum fileType) {
        this.fileType = fileType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="File type of the document")
    @JsonProperty(value="fileType")
    public FileTypeEnum getFileType() {
        return this.fileType;
    }

    public void setFileType(FileTypeEnum fileType) {
        this.fileType = fileType;
    }

    public KnowledgeExportJobRequest sourceId(String sourceId) {
        this.sourceId = sourceId;
        return this;
    }

    @ApiModelProperty(example="null", value="Knowledge integration source id.")
    @JsonProperty(value="sourceId")
    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public KnowledgeExportJobRequest jsonFileVersion(Integer jsonFileVersion) {
        this.jsonFileVersion = jsonFileVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="Requested version of the exported json file. Available versions are 2 and 3, default is 2")
    @JsonProperty(value="jsonFileVersion")
    public Integer getJsonFileVersion() {
        return this.jsonFileVersion;
    }

    public void setJsonFileVersion(Integer jsonFileVersion) {
        this.jsonFileVersion = jsonFileVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeExportJobRequest knowledgeExportJobRequest = (KnowledgeExportJobRequest)o;
        return Objects.equals(this.exportFilter, knowledgeExportJobRequest.exportFilter) && Objects.equals((Object)this.fileType, (Object)knowledgeExportJobRequest.fileType) && Objects.equals(this.sourceId, knowledgeExportJobRequest.sourceId) && Objects.equals(this.jsonFileVersion, knowledgeExportJobRequest.jsonFileVersion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.exportFilter, this.fileType, this.sourceId, this.jsonFileVersion});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeExportJobRequest {\n");
        sb.append("    exportFilter: ").append(this.toIndentedString(this.exportFilter)).append("\n");
        sb.append("    fileType: ").append(this.toIndentedString((Object)this.fileType)).append("\n");
        sb.append("    sourceId: ").append(this.toIndentedString(this.sourceId)).append("\n");
        sb.append("    jsonFileVersion: ").append(this.toIndentedString(this.jsonFileVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=FileTypeEnumDeserializer.class)
    public static enum FileTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        JSON("Json"),
        CSV("Csv"),
        XLSX("Xlsx");

        private String value;

        private FileTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FileTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FileTypeEnum value : FileTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FileTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FileTypeEnumDeserializer
    extends StdDeserializer<FileTypeEnum> {
        public FileTypeEnumDeserializer() {
            super(FileTypeEnumDeserializer.class);
        }

        public FileTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FileTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

