/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AlertNotification;
import com.mypurecloud.sdk.v2.model.AlertRuleProperties;
import com.mypurecloud.sdk.v2.model.AlertSummary;
import com.mypurecloud.sdk.v2.model.CommonRuleConditions;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class CommonAlert
implements Serializable {
    private String id = null;
    private String name = null;
    private UserReference user = null;
    private AlertRuleProperties rule = null;
    private List<AlertNotification> notifications = null;
    private Date dateStart = null;
    private Date dateEnd = null;
    private Boolean active = null;
    private Boolean unread = null;
    private Long waitBetweenNotificationMs = null;
    private Boolean muted = null;
    private Boolean snoozed = null;
    private Date dateMutedUntil = null;
    private Date dateSnoozedUntil = null;
    private CommonRuleConditions conditions = null;
    private String conversationId = null;
    private AlertSummary alertSummary = null;
    private String ruleUri = null;
    private String selfUri = null;

    public CommonAlert() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.notifications = new ArrayList<AlertNotification>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public CommonAlert name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CommonAlert user(UserReference user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The user who created the rule that triggered the alert.")
    @JsonProperty(value="user")
    public UserReference getUser() {
        return this.user;
    }

    public void setUser(UserReference user) {
        this.user = user;
    }

    public CommonAlert rule(AlertRuleProperties rule) {
        this.rule = rule;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The properties of the rule that triggered the alert.")
    @JsonProperty(value="rule")
    public AlertRuleProperties getRule() {
        return this.rule;
    }

    public void setRule(AlertRuleProperties rule) {
        this.rule = rule;
    }

    public CommonAlert notifications(List<AlertNotification> notifications) {
        this.notifications = notifications;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The collection of notification methods and the ids of users who were notified by those methods.")
    @JsonProperty(value="notifications")
    public List<AlertNotification> getNotifications() {
        return this.notifications;
    }

    public void setNotifications(List<AlertNotification> notifications) {
        this.notifications = notifications;
    }

    public CommonAlert dateStart(Date dateStart) {
        this.dateStart = dateStart;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The timestamp of when the alert was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateStart")
    public Date getDateStart() {
        return this.dateStart;
    }

    public void setDateStart(Date dateStart) {
        this.dateStart = dateStart;
    }

    public CommonAlert dateEnd(Date dateEnd) {
        this.dateEnd = dateEnd;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp of when the alert ended. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateEnd")
    public Date getDateEnd() {
        return this.dateEnd;
    }

    public void setDateEnd(Date dateEnd) {
        this.dateEnd = dateEnd;
    }

    public CommonAlert active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Indicates if an alert is currently active.")
    @JsonProperty(value="active")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public CommonAlert unread(Boolean unread) {
        this.unread = unread;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Indicates if an alert has not been read.")
    @JsonProperty(value="unread")
    public Boolean getUnread() {
        return this.unread;
    }

    public void setUnread(Boolean unread) {
        this.unread = unread;
    }

    public CommonAlert waitBetweenNotificationMs(Long waitBetweenNotificationMs) {
        this.waitBetweenNotificationMs = waitBetweenNotificationMs;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The amount of time to wait between notification. Time is in milliseconds.")
    @JsonProperty(value="waitBetweenNotificationMs")
    public Long getWaitBetweenNotificationMs() {
        return this.waitBetweenNotificationMs;
    }

    public void setWaitBetweenNotificationMs(Long waitBetweenNotificationMs) {
        this.waitBetweenNotificationMs = waitBetweenNotificationMs;
    }

    public CommonAlert muted(Boolean muted) {
        this.muted = muted;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Flag indicating if the alert is in a muted state.")
    @JsonProperty(value="muted")
    public Boolean getMuted() {
        return this.muted;
    }

    public void setMuted(Boolean muted) {
        this.muted = muted;
    }

    public CommonAlert snoozed(Boolean snoozed) {
        this.snoozed = snoozed;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Flag indicating if the alert is in a snoozed state.")
    @JsonProperty(value="snoozed")
    public Boolean getSnoozed() {
        return this.snoozed;
    }

    public void setSnoozed(Boolean snoozed) {
        this.snoozed = snoozed;
    }

    public CommonAlert dateMutedUntil(Date dateMutedUntil) {
        this.dateMutedUntil = dateMutedUntil;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Timestamp of when the mute status of the alert should end. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateMutedUntil")
    public Date getDateMutedUntil() {
        return this.dateMutedUntil;
    }

    public void setDateMutedUntil(Date dateMutedUntil) {
        this.dateMutedUntil = dateMutedUntil;
    }

    public CommonAlert dateSnoozedUntil(Date dateSnoozedUntil) {
        this.dateSnoozedUntil = dateSnoozedUntil;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Timestamp of when the snooze status of the alert should end. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateSnoozedUntil")
    public Date getDateSnoozedUntil() {
        return this.dateSnoozedUntil;
    }

    public void setDateSnoozedUntil(Date dateSnoozedUntil) {
        this.dateSnoozedUntil = dateSnoozedUntil;
    }

    public CommonAlert conditions(CommonRuleConditions conditions) {
        this.conditions = conditions;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The conditions that make up the rule.")
    @JsonProperty(value="conditions")
    public CommonRuleConditions getConditions() {
        return this.conditions;
    }

    public void setConditions(CommonRuleConditions conditions) {
        this.conditions = conditions;
    }

    public CommonAlert conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the conversation instance that caused the alert to trigger.")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public CommonAlert alertSummary(AlertSummary alertSummary) {
        this.alertSummary = alertSummary;
        return this;
    }

    @ApiModelProperty(example="null", value="Summary of the alert status of the entities defined in the conditions.  Is set when rule has instance-based or team member based rule predicates")
    @JsonProperty(value="alertSummary")
    public AlertSummary getAlertSummary() {
        return this.alertSummary;
    }

    public void setAlertSummary(AlertSummary alertSummary) {
        this.alertSummary = alertSummary;
    }

    public CommonAlert ruleUri(String ruleUri) {
        this.ruleUri = ruleUri;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="ruleUri")
    public String getRuleUri() {
        return this.ruleUri;
    }

    public void setRuleUri(String ruleUri) {
        this.ruleUri = ruleUri;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonAlert commonAlert = (CommonAlert)o;
        return Objects.equals(this.id, commonAlert.id) && Objects.equals(this.name, commonAlert.name) && Objects.equals(this.user, commonAlert.user) && Objects.equals(this.rule, commonAlert.rule) && Objects.equals(this.notifications, commonAlert.notifications) && Objects.equals(this.dateStart, commonAlert.dateStart) && Objects.equals(this.dateEnd, commonAlert.dateEnd) && Objects.equals(this.active, commonAlert.active) && Objects.equals(this.unread, commonAlert.unread) && Objects.equals(this.waitBetweenNotificationMs, commonAlert.waitBetweenNotificationMs) && Objects.equals(this.muted, commonAlert.muted) && Objects.equals(this.snoozed, commonAlert.snoozed) && Objects.equals(this.dateMutedUntil, commonAlert.dateMutedUntil) && Objects.equals(this.dateSnoozedUntil, commonAlert.dateSnoozedUntil) && Objects.equals(this.conditions, commonAlert.conditions) && Objects.equals(this.conversationId, commonAlert.conversationId) && Objects.equals(this.alertSummary, commonAlert.alertSummary) && Objects.equals(this.ruleUri, commonAlert.ruleUri) && Objects.equals(this.selfUri, commonAlert.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.user, this.rule, this.notifications, this.dateStart, this.dateEnd, this.active, this.unread, this.waitBetweenNotificationMs, this.muted, this.snoozed, this.dateMutedUntil, this.dateSnoozedUntil, this.conditions, this.conversationId, this.alertSummary, this.ruleUri, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CommonAlert {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    rule: ").append(this.toIndentedString(this.rule)).append("\n");
        sb.append("    notifications: ").append(this.toIndentedString(this.notifications)).append("\n");
        sb.append("    dateStart: ").append(this.toIndentedString(this.dateStart)).append("\n");
        sb.append("    dateEnd: ").append(this.toIndentedString(this.dateEnd)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    unread: ").append(this.toIndentedString(this.unread)).append("\n");
        sb.append("    waitBetweenNotificationMs: ").append(this.toIndentedString(this.waitBetweenNotificationMs)).append("\n");
        sb.append("    muted: ").append(this.toIndentedString(this.muted)).append("\n");
        sb.append("    snoozed: ").append(this.toIndentedString(this.snoozed)).append("\n");
        sb.append("    dateMutedUntil: ").append(this.toIndentedString(this.dateMutedUntil)).append("\n");
        sb.append("    dateSnoozedUntil: ").append(this.toIndentedString(this.dateSnoozedUntil)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    alertSummary: ").append(this.toIndentedString(this.alertSummary)).append("\n");
        sb.append("    ruleUri: ").append(this.toIndentedString(this.ruleUri)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

