/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.BotChannel;
import com.mypurecloud.sdk.v2.model.Entity;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class BotFlowSession
implements Serializable {
    private String id = null;
    private Entity flow = null;
    private BotChannel channel = null;
    private String language = null;
    private String endLanguage = null;
    private BotResultEnum botResult = null;
    private BotResultCategoryEnum botResultCategory = null;
    private Date dateCreated = null;
    private Date dateCompleted = null;
    private AddressableEntityRef conversation = null;

    public BotFlowSession() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public BotFlowSession id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the bot session.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BotFlowSession flow(Entity flow) {
        this.flow = flow;
        return this;
    }

    @ApiModelProperty(example="null", value="The flow associated to this bot session.")
    @JsonProperty(value="flow")
    public Entity getFlow() {
        return this.flow;
    }

    public void setFlow(Entity flow) {
        this.flow = flow;
    }

    public BotFlowSession channel(BotChannel channel) {
        this.channel = channel;
        return this;
    }

    @ApiModelProperty(example="null", value="Channel-specific information that describes the message channel/provider.")
    @JsonProperty(value="channel")
    public BotChannel getChannel() {
        return this.channel;
    }

    public void setChannel(BotChannel channel) {
        this.channel = channel;
    }

    public BotFlowSession language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(example="null", value="The initial language of operation for the session.")
    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public BotFlowSession endLanguage(String endLanguage) {
        this.endLanguage = endLanguage;
        return this;
    }

    @ApiModelProperty(example="null", value="The language of the session at the time the session ended")
    @JsonProperty(value="endLanguage")
    public String getEndLanguage() {
        return this.endLanguage;
    }

    public void setEndLanguage(String endLanguage) {
        this.endLanguage = endLanguage;
    }

    public BotFlowSession botResult(BotResultEnum botResult) {
        this.botResult = botResult;
        return this;
    }

    @ApiModelProperty(example="null", value="The reason for session termination.")
    @JsonProperty(value="botResult")
    public BotResultEnum getBotResult() {
        return this.botResult;
    }

    public void setBotResult(BotResultEnum botResult) {
        this.botResult = botResult;
    }

    public BotFlowSession botResultCategory(BotResultCategoryEnum botResultCategory) {
        this.botResultCategory = botResultCategory;
        return this;
    }

    @ApiModelProperty(example="null", value="The category of result for the session.")
    @JsonProperty(value="botResultCategory")
    public BotResultCategoryEnum getBotResultCategory() {
        return this.botResultCategory;
    }

    public void setBotResultCategory(BotResultCategoryEnum botResultCategory) {
        this.botResultCategory = botResultCategory;
    }

    public BotFlowSession dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="Timestamp indicating when the session was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public BotFlowSession dateCompleted(Date dateCompleted) {
        this.dateCompleted = dateCompleted;
        return this;
    }

    @ApiModelProperty(example="null", value="Timestamp indicating when the session was completed. Note: The 'interval' query param uses this timestamp to filter the output. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCompleted")
    public Date getDateCompleted() {
        return this.dateCompleted;
    }

    public void setDateCompleted(Date dateCompleted) {
        this.dateCompleted = dateCompleted;
    }

    @ApiModelProperty(example="null", value="The conversation details, across potentially multiple Bot Flow sessions.")
    @JsonProperty(value="conversation")
    public AddressableEntityRef getConversation() {
        return this.conversation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BotFlowSession botFlowSession = (BotFlowSession)o;
        return Objects.equals(this.id, botFlowSession.id) && Objects.equals(this.flow, botFlowSession.flow) && Objects.equals(this.channel, botFlowSession.channel) && Objects.equals(this.language, botFlowSession.language) && Objects.equals(this.endLanguage, botFlowSession.endLanguage) && Objects.equals((Object)this.botResult, (Object)botFlowSession.botResult) && Objects.equals((Object)this.botResultCategory, (Object)botFlowSession.botResultCategory) && Objects.equals(this.dateCreated, botFlowSession.dateCreated) && Objects.equals(this.dateCompleted, botFlowSession.dateCompleted) && Objects.equals(this.conversation, botFlowSession.conversation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.flow, this.channel, this.language, this.endLanguage, this.botResult, this.botResultCategory, this.dateCreated, this.dateCompleted, this.conversation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BotFlowSession {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    flow: ").append(this.toIndentedString(this.flow)).append("\n");
        sb.append("    channel: ").append(this.toIndentedString(this.channel)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    endLanguage: ").append(this.toIndentedString(this.endLanguage)).append("\n");
        sb.append("    botResult: ").append(this.toIndentedString((Object)this.botResult)).append("\n");
        sb.append("    botResultCategory: ").append(this.toIndentedString((Object)this.botResultCategory)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateCompleted: ").append(this.toIndentedString(this.dateCompleted)).append("\n");
        sb.append("    conversation: ").append(this.toIndentedString(this.conversation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=BotResultEnumDeserializer.class)
    public static enum BotResultEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNKNOWN("Unknown"),
        EXITREQUESTEDBYUSER("ExitRequestedByUser"),
        EXITREQUESTEDBYBOT("ExitRequestedByBot"),
        EXITERROR("ExitError"),
        EXITRECOGNITIONFAILURE("ExitRecognitionFailure"),
        DISCONNECTREQUESTEDBYUSER("DisconnectRequestedByUser"),
        DISCONNECTREQUESTEDBYBOT("DisconnectRequestedByBot"),
        DISCONNECTSESSIONEXPIRED("DisconnectSessionExpired"),
        DISCONNECTERROR("DisconnectError"),
        DISCONNECTRECOGNITIONFAILURE("DisconnectRecognitionFailure"),
        TRANSFERTOACD("TransferToACD");

        private String value;

        private BotResultEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static BotResultEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (BotResultEnum value : BotResultEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return BotResultEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=BotResultCategoryEnumDeserializer.class)
    public static enum BotResultCategoryEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNKNOWN("Unknown"),
        USEREXIT("UserExit"),
        BOTEXIT("BotExit"),
        ERROR("Error"),
        RECOGNITIONFAILURE("RecognitionFailure"),
        USERDISCONNECT("UserDisconnect"),
        BOTDISCONNECT("BotDisconnect"),
        SESSIONEXPIRED("SessionExpired"),
        TRANSFER("Transfer");

        private String value;

        private BotResultCategoryEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static BotResultCategoryEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (BotResultCategoryEnum value : BotResultCategoryEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return BotResultCategoryEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class BotResultCategoryEnumDeserializer
    extends StdDeserializer<BotResultCategoryEnum> {
        public BotResultCategoryEnumDeserializer() {
            super(BotResultCategoryEnumDeserializer.class);
        }

        public BotResultCategoryEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return BotResultCategoryEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class BotResultEnumDeserializer
    extends StdDeserializer<BotResultEnum> {
        public BotResultEnumDeserializer() {
            super(BotResultEnumDeserializer.class);
        }

        public BotResultEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return BotResultEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

