/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.Assistant;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class AssistantQueue
implements Serializable {
    private String id = null;
    private List<MediaTypesEnum> mediaTypes = null;
    private Assistant assistant = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private String selfUri = null;

    public AssistantQueue() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.mediaTypes = new ArrayList<MediaTypesEnum>();
        }
    }

    public AssistantQueue id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The globally unique identifier for the queue.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AssistantQueue mediaTypes(List<MediaTypesEnum> mediaTypes) {
        this.mediaTypes = mediaTypes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="List of media Types in which the assistant is activated for this queue.")
    @JsonProperty(value="mediaTypes")
    public List<MediaTypesEnum> getMediaTypes() {
        return this.mediaTypes;
    }

    public void setMediaTypes(List<MediaTypesEnum> mediaTypes) {
        this.mediaTypes = mediaTypes;
    }

    @ApiModelProperty(example="null", value="Assistant to which the queue is assigned.")
    @JsonProperty(value="assistant")
    public Assistant getAssistant() {
        return this.assistant;
    }

    @ApiModelProperty(example="null", value="Date when the assistant queue was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Date when the assistant queue was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssistantQueue assistantQueue = (AssistantQueue)o;
        return Objects.equals(this.id, assistantQueue.id) && Objects.equals(this.mediaTypes, assistantQueue.mediaTypes) && Objects.equals(this.assistant, assistantQueue.assistant) && Objects.equals(this.dateCreated, assistantQueue.dateCreated) && Objects.equals(this.dateModified, assistantQueue.dateModified) && Objects.equals(this.selfUri, assistantQueue.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.mediaTypes, this.assistant, this.dateCreated, this.dateModified, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssistantQueue {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    mediaTypes: ").append(this.toIndentedString(this.mediaTypes)).append("\n");
        sb.append("    assistant: ").append(this.toIndentedString(this.assistant)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MediaTypesEnumDeserializer.class)
    public static enum MediaTypesEnum {
        CALL("Call"),
        EMAIL("Email"),
        MESSAGE("Message");

        private String value;

        private MediaTypesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypesEnum value : MediaTypesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaTypesEnumDeserializer
    extends StdDeserializer<MediaTypesEnum> {
        public MediaTypesEnumDeserializer() {
            super(MediaTypesEnumDeserializer.class);
        }

        public MediaTypesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypesEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

