/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.Touchpoint;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class OutcomeAttributionRequest
implements Serializable {
    private String outcomeId = null;
    private String externalContactId = null;
    private BigDecimal associatedValue = null;
    private List<Touchpoint> touchpoints = null;
    private Date createdDate = null;

    public OutcomeAttributionRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.touchpoints = new ArrayList<Touchpoint>();
        }
    }

    public OutcomeAttributionRequest outcomeId(String outcomeId) {
        this.outcomeId = outcomeId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ID of Outcome.")
    @JsonProperty(value="outcomeId")
    public String getOutcomeId() {
        return this.outcomeId;
    }

    public void setOutcomeId(String outcomeId) {
        this.outcomeId = outcomeId;
    }

    public OutcomeAttributionRequest externalContactId(String externalContactId) {
        this.externalContactId = externalContactId;
        return this;
    }

    @ApiModelProperty(example="null", value="The external contact ID of the customer who achieved the outcome.")
    @JsonProperty(value="externalContactId")
    public String getExternalContactId() {
        return this.externalContactId;
    }

    public void setExternalContactId(String externalContactId) {
        this.externalContactId = externalContactId;
    }

    public OutcomeAttributionRequest associatedValue(BigDecimal associatedValue) {
        this.associatedValue = associatedValue;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The total value associated with the customer's outcome.")
    @JsonProperty(value="associatedValue")
    public BigDecimal getAssociatedValue() {
        return this.associatedValue;
    }

    public void setAssociatedValue(BigDecimal associatedValue) {
        this.associatedValue = associatedValue;
    }

    public OutcomeAttributionRequest touchpoints(List<Touchpoint> touchpoints) {
        this.touchpoints = touchpoints;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="List of interactions that led to this outcome being achieved.")
    @JsonProperty(value="touchpoints")
    public List<Touchpoint> getTouchpoints() {
        return this.touchpoints;
    }

    public void setTouchpoints(List<Touchpoint> touchpoints) {
        this.touchpoints = touchpoints;
    }

    public OutcomeAttributionRequest createdDate(Date createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Date outcome was achieved. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="createdDate")
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutcomeAttributionRequest outcomeAttributionRequest = (OutcomeAttributionRequest)o;
        return Objects.equals(this.outcomeId, outcomeAttributionRequest.outcomeId) && Objects.equals(this.externalContactId, outcomeAttributionRequest.externalContactId) && Objects.equals(this.associatedValue, outcomeAttributionRequest.associatedValue) && Objects.equals(this.touchpoints, outcomeAttributionRequest.touchpoints) && Objects.equals(this.createdDate, outcomeAttributionRequest.createdDate);
    }

    public int hashCode() {
        return Objects.hash(this.outcomeId, this.externalContactId, this.associatedValue, this.touchpoints, this.createdDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OutcomeAttributionRequest {\n");
        sb.append("    outcomeId: ").append(this.toIndentedString(this.outcomeId)).append("\n");
        sb.append("    externalContactId: ").append(this.toIndentedString(this.externalContactId)).append("\n");
        sb.append("    associatedValue: ").append(this.toIndentedString(this.associatedValue)).append("\n");
        sb.append("    touchpoints: ").append(this.toIndentedString(this.touchpoints)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

