/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.Division;
import com.mypurecloud.sdk.v2.model.UserReference;
import com.mypurecloud.sdk.v2.model.WorkdayValuesMetricItem;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Objects;

public class MetricValueTrendAverage
implements Serializable {
    private LocalDate dateStartWorkday = null;
    private LocalDate dateEndWorkday = null;
    private LocalDate dateReferenceWorkday = null;
    private Division division = null;
    private UserReference user = null;
    private String timezone = null;
    private WorkdayValuesMetricItem result = null;
    private AddressableEntityRef performanceProfile = null;
    private AddressableEntityRef metric = null;

    public MetricValueTrendAverage() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The targeted start workday. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateStartWorkday")
    public LocalDate getDateStartWorkday() {
        return this.dateStartWorkday;
    }

    @ApiModelProperty(example="null", value="The targeted end workday. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateEndWorkday")
    public LocalDate getDateEndWorkday() {
        return this.dateEndWorkday;
    }

    @ApiModelProperty(example="null", value="The targeted reference workday. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateReferenceWorkday")
    public LocalDate getDateReferenceWorkday() {
        return this.dateReferenceWorkday;
    }

    @ApiModelProperty(example="null", value="The targeted division for the metrics")
    @JsonProperty(value="division")
    public Division getDivision() {
        return this.division;
    }

    @ApiModelProperty(example="null", value="The targeted user for the metrics")
    @JsonProperty(value="user")
    public UserReference getUser() {
        return this.user;
    }

    @ApiModelProperty(example="null", value="The time zone used for aggregating metric values")
    @JsonProperty(value="timezone")
    public String getTimezone() {
        return this.timezone;
    }

    @ApiModelProperty(example="null", value="The metric value trend and average")
    @JsonProperty(value="result")
    public WorkdayValuesMetricItem getResult() {
        return this.result;
    }

    @ApiModelProperty(example="null", value="The targeted performance profile for the average points")
    @JsonProperty(value="performanceProfile")
    public AddressableEntityRef getPerformanceProfile() {
        return this.performanceProfile;
    }

    @ApiModelProperty(example="null", value="The targeted performance profile for the average points")
    @JsonProperty(value="metric")
    public AddressableEntityRef getMetric() {
        return this.metric;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricValueTrendAverage metricValueTrendAverage = (MetricValueTrendAverage)o;
        return Objects.equals(this.dateStartWorkday, metricValueTrendAverage.dateStartWorkday) && Objects.equals(this.dateEndWorkday, metricValueTrendAverage.dateEndWorkday) && Objects.equals(this.dateReferenceWorkday, metricValueTrendAverage.dateReferenceWorkday) && Objects.equals(this.division, metricValueTrendAverage.division) && Objects.equals(this.user, metricValueTrendAverage.user) && Objects.equals(this.timezone, metricValueTrendAverage.timezone) && Objects.equals(this.result, metricValueTrendAverage.result) && Objects.equals(this.performanceProfile, metricValueTrendAverage.performanceProfile) && Objects.equals(this.metric, metricValueTrendAverage.metric);
    }

    public int hashCode() {
        return Objects.hash(this.dateStartWorkday, this.dateEndWorkday, this.dateReferenceWorkday, this.division, this.user, this.timezone, this.result, this.performanceProfile, this.metric);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricValueTrendAverage {\n");
        sb.append("    dateStartWorkday: ").append(this.toIndentedString(this.dateStartWorkday)).append("\n");
        sb.append("    dateEndWorkday: ").append(this.toIndentedString(this.dateEndWorkday)).append("\n");
        sb.append("    dateReferenceWorkday: ").append(this.toIndentedString(this.dateReferenceWorkday)).append("\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("    result: ").append(this.toIndentedString(this.result)).append("\n");
        sb.append("    performanceProfile: ").append(this.toIndentedString(this.performanceProfile)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString(this.metric)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

