/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class EmailThreadingSettings
implements Serializable {
    private Boolean startNewConversationOnSubjectChange = null;
    private Long timeoutInMinutes = null;

    public EmailThreadingSettings startNewConversationOnSubjectChange(Boolean startNewConversationOnSubjectChange) {
        this.startNewConversationOnSubjectChange = startNewConversationOnSubjectChange;
        return this;
    }

    @ApiModelProperty(example="null", value="This setting controls whether a new conversation is started if the subject of an inbound email is different from the subject of the current conversation. RE: and FWD: prefixes in any language are ignored.")
    @JsonProperty(value="startNewConversationOnSubjectChange")
    public Boolean getStartNewConversationOnSubjectChange() {
        return this.startNewConversationOnSubjectChange;
    }

    public void setStartNewConversationOnSubjectChange(Boolean startNewConversationOnSubjectChange) {
        this.startNewConversationOnSubjectChange = startNewConversationOnSubjectChange;
    }

    public EmailThreadingSettings timeoutInMinutes(Long timeoutInMinutes) {
        this.timeoutInMinutes = timeoutInMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="In minutes, how long an email conversation should keep being threaded after being disconnected.")
    @JsonProperty(value="timeoutInMinutes")
    public Long getTimeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public void setTimeoutInMinutes(Long timeoutInMinutes) {
        this.timeoutInMinutes = timeoutInMinutes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailThreadingSettings emailThreadingSettings = (EmailThreadingSettings)o;
        return Objects.equals(this.startNewConversationOnSubjectChange, emailThreadingSettings.startNewConversationOnSubjectChange) && Objects.equals(this.timeoutInMinutes, emailThreadingSettings.timeoutInMinutes);
    }

    public int hashCode() {
        return Objects.hash(this.startNewConversationOnSubjectChange, this.timeoutInMinutes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailThreadingSettings {\n");
        sb.append("    startNewConversationOnSubjectChange: ").append(this.toIndentedString(this.startNewConversationOnSubjectChange)).append("\n");
        sb.append("    timeoutInMinutes: ").append(this.toIndentedString(this.timeoutInMinutes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

