/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class HistoricalImportStatus
implements Serializable {
    private String requestId = null;
    private Date dateImportEnded = null;
    private Date dateImportStarted = null;
    private StatusEnum status = null;
    private String error = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private Boolean active = null;
    private TypeEnum type = null;
    private String fileName = null;
    private Long fileSize = null;

    @ApiModelProperty(example="null", value="Request id of the historical import in the organization")
    @JsonProperty(value="requestId")
    public String getRequestId() {
        return this.requestId;
    }

    @ApiModelProperty(example="null", value="The last day of the data you are importing. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateImportEnded")
    public Date getDateImportEnded() {
        return this.dateImportEnded;
    }

    @ApiModelProperty(example="null", value="The first day of the data you are importing. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateImportStarted")
    public Date getDateImportStarted() {
        return this.dateImportStarted;
    }

    @ApiModelProperty(example="null", value="Status of the historical import in the organization.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    @ApiModelProperty(example="null", value="Error occured if the status of the import is failed")
    @JsonProperty(value="error")
    public String getError() {
        return this.error;
    }

    @ApiModelProperty(example="null", value="Date in which the historical import is initiated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Date in which the historical import is modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="Whether this historical import is active or not")
    @JsonProperty(value="active")
    public Boolean getActive() {
        return this.active;
    }

    @ApiModelProperty(example="null", value="Whether this historical import is of type csv or json")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    @ApiModelProperty(example="null", value="Name of the file that you are importing.")
    @JsonProperty(value="fileName")
    public String getFileName() {
        return this.fileName;
    }

    @ApiModelProperty(example="null", value="Size of the file that you are importing.")
    @JsonProperty(value="fileSize")
    public Long getFileSize() {
        return this.fileSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricalImportStatus historicalImportStatus = (HistoricalImportStatus)o;
        return Objects.equals(this.requestId, historicalImportStatus.requestId) && Objects.equals(this.dateImportEnded, historicalImportStatus.dateImportEnded) && Objects.equals(this.dateImportStarted, historicalImportStatus.dateImportStarted) && Objects.equals((Object)this.status, (Object)historicalImportStatus.status) && Objects.equals(this.error, historicalImportStatus.error) && Objects.equals(this.dateCreated, historicalImportStatus.dateCreated) && Objects.equals(this.dateModified, historicalImportStatus.dateModified) && Objects.equals(this.active, historicalImportStatus.active) && Objects.equals((Object)this.type, (Object)historicalImportStatus.type) && Objects.equals(this.fileName, historicalImportStatus.fileName) && Objects.equals(this.fileSize, historicalImportStatus.fileSize);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requestId, this.dateImportEnded, this.dateImportStarted, this.status, this.error, this.dateCreated, this.dateModified, this.active, this.type, this.fileName, this.fileSize});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoricalImportStatus {\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    dateImportEnded: ").append(this.toIndentedString(this.dateImportEnded)).append("\n");
        sb.append("    dateImportStarted: ").append(this.toIndentedString(this.dateImportStarted)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    fileSize: ").append(this.toIndentedString(this.fileSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INITIATED("Initiated"),
        INPROGRESS("InProgress"),
        PENDING("Pending"),
        SUCCESS("Success"),
        FAILED("Failed"),
        CANCELLED("Cancelled"),
        PURGED("Purged"),
        PURGEPENDING("PurgePending");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CSV("Csv"),
        JSON("Json");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

