/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetConversationRecordingsRequest {
    private String conversationId;
    private Integer maxWaitMs;
    private String formatId;
    private List<String> mediaFormats;
    private String locale;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public GetConversationRecordingsRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public Integer getMaxWaitMs() {
        return this.maxWaitMs;
    }

    public void setMaxWaitMs(Integer maxWaitMs) {
        this.maxWaitMs = maxWaitMs;
    }

    public GetConversationRecordingsRequest withMaxWaitMs(Integer maxWaitMs) {
        this.setMaxWaitMs(maxWaitMs);
        return this;
    }

    public String getFormatId() {
        return this.formatId;
    }

    public void setFormatId(String formatId) {
        this.formatId = formatId;
    }

    public GetConversationRecordingsRequest withFormatId(String formatId) {
        this.setFormatId(formatId);
        return this;
    }

    public List<String> getMediaFormats() {
        return this.mediaFormats;
    }

    public void setMediaFormats(List<String> mediaFormats) {
        this.mediaFormats = mediaFormats;
    }

    public GetConversationRecordingsRequest withMediaFormats(List<String> mediaFormats) {
        this.setMediaFormats(mediaFormats);
        return this;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public GetConversationRecordingsRequest withLocale(String locale) {
        this.setLocale(locale);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetConversationRecordingsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for GetConversationRecordingsRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/conversations/{conversationId}/recordings").withPathParameter("conversationId", this.conversationId).withQueryParameters("maxWaitMs", "", this.maxWaitMs).withQueryParameters("formatId", "", this.formatId).withQueryParameters("mediaFormats", "multi", this.mediaFormats).withQueryParameters("locale", "", this.locale).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId) {
        return new Builder().withRequiredParams(conversationId);
    }

    public static class Builder {
        private final GetConversationRecordingsRequest request = new GetConversationRecordingsRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withMaxWaitMs(Integer maxWaitMs) {
            this.request.setMaxWaitMs(maxWaitMs);
            return this;
        }

        public Builder withFormatId(String formatId) {
            this.request.setFormatId(formatId);
            return this;
        }

        public Builder withFormatId(formatIdValues formatId) {
            this.request.setFormatId(formatId.toString());
            return this;
        }

        public Builder withMediaFormats(List<String> mediaFormats) {
            this.request.setMediaFormats(mediaFormats);
            return this;
        }

        public Builder withLocale(String locale) {
            this.request.setLocale(locale);
            return this;
        }

        public Builder withRequiredParams(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public GetConversationRecordingsRequest build() {
            if (this.request.conversationId == null) {
                throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for GetConversationRecordingsRequest.");
            }
            return this.request;
        }
    }

    public static enum formatIdValues {
        WAV("WAV"),
        WEBM("WEBM"),
        WAV_ULAW("WAV_ULAW"),
        OGG_VORBIS("OGG_VORBIS"),
        OGG_OPUS("OGG_OPUS"),
        MP3("MP3"),
        NONE("NONE");

        private String value;

        private formatIdValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static formatIdValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (formatIdValues value : formatIdValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return formatIdValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

