/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LearningScheduleSlotsQueryRequest
implements Serializable {
    private String interval = null;
    private Integer lengthInMinutes = null;
    private List<String> userIds = new ArrayList<String>();
    private String interruptibleAssignmentId = null;

    public LearningScheduleSlotsQueryRequest interval(String interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Range of time to get slots for scheduling learning activities. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public LearningScheduleSlotsQueryRequest lengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The duration of Learning Assignment to schedule in 15 minutes granularity")
    @JsonProperty(value="lengthInMinutes")
    public Integer getLengthInMinutes() {
        return this.lengthInMinutes;
    }

    public void setLengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
    }

    public LearningScheduleSlotsQueryRequest userIds(List<String> userIds) {
        this.userIds = userIds;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The user IDs for which to fetch schedules. Must be only 1.")
    @JsonProperty(value="userIds")
    public List<String> getUserIds() {
        return this.userIds;
    }

    public void setUserIds(List<String> userIds) {
        this.userIds = userIds;
    }

    public LearningScheduleSlotsQueryRequest interruptibleAssignmentId(String interruptibleAssignmentId) {
        this.interruptibleAssignmentId = interruptibleAssignmentId;
        return this;
    }

    @ApiModelProperty(example="null", value="Assignment ID to exclude from consideration when determining blocked slots")
    @JsonProperty(value="interruptibleAssignmentId")
    public String getInterruptibleAssignmentId() {
        return this.interruptibleAssignmentId;
    }

    public void setInterruptibleAssignmentId(String interruptibleAssignmentId) {
        this.interruptibleAssignmentId = interruptibleAssignmentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LearningScheduleSlotsQueryRequest learningScheduleSlotsQueryRequest = (LearningScheduleSlotsQueryRequest)o;
        return Objects.equals(this.interval, learningScheduleSlotsQueryRequest.interval) && Objects.equals(this.lengthInMinutes, learningScheduleSlotsQueryRequest.lengthInMinutes) && Objects.equals(this.userIds, learningScheduleSlotsQueryRequest.userIds) && Objects.equals(this.interruptibleAssignmentId, learningScheduleSlotsQueryRequest.interruptibleAssignmentId);
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.lengthInMinutes, this.userIds, this.interruptibleAssignmentId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LearningScheduleSlotsQueryRequest {\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    lengthInMinutes: ").append(this.toIndentedString(this.lengthInMinutes)).append("\n");
        sb.append("    userIds: ").append(this.toIndentedString(this.userIds)).append("\n");
        sb.append("    interruptibleAssignmentId: ").append(this.toIndentedString(this.interruptibleAssignmentId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

