/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class ConversationProfile
implements Serializable {
    private LanguageCodeEnum languageCode = null;
    private String name = null;

    public ConversationProfile languageCode(LanguageCodeEnum languageCode) {
        this.languageCode = languageCode;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The language code supported by the conversation profile belonging to a particular project for Dialogflow.")
    @JsonProperty(value="languageCode")
    public LanguageCodeEnum getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(LanguageCodeEnum languageCode) {
        this.languageCode = languageCode;
    }

    public ConversationProfile name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the conversation profile belonging to a particular project for Dialogflow")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationProfile conversationProfile = (ConversationProfile)o;
        return Objects.equals((Object)this.languageCode, (Object)conversationProfile.languageCode) && Objects.equals(this.name, conversationProfile.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.languageCode, this.name});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationProfile {\n");
        sb.append("    languageCode: ").append(this.toIndentedString((Object)this.languageCode)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=LanguageCodeEnumDeserializer.class)
    public static enum LanguageCodeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EN("en"),
        EN_AU("en-AU"),
        EN_CA("en-CA"),
        EN_GB("en-GB"),
        EN_IN("en-IN"),
        EN_US("en-US");

        private String value;

        private LanguageCodeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static LanguageCodeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (LanguageCodeEnum value : LanguageCodeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return LanguageCodeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class LanguageCodeEnumDeserializer
    extends StdDeserializer<LanguageCodeEnum> {
        public LanguageCodeEnumDeserializer() {
            super(LanguageCodeEnumDeserializer.class);
        }

        public LanguageCodeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return LanguageCodeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

