/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.Subject;
import com.mypurecloud.sdk.v2.model.TypedAttribute;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class AuthorizationPolicy
implements Serializable {
    private String id = null;
    private String name = null;
    private String targetResource = null;
    private Subject subject = null;
    private EffectEnum effect = null;
    private Object condition = null;
    private String description = null;
    private Date dateModified = null;
    private Map<String, TypedAttribute> presetAttributes = null;
    private Boolean active = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public AuthorizationPolicy name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(example="null", value="The targeted resource to which the policy should apply, in the form of domain:entity:action")
    @JsonProperty(value="targetResource")
    public String getTargetResource() {
        return this.targetResource;
    }

    public AuthorizationPolicy subject(Subject subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The subject to whom the policy will apply, including type and id")
    @JsonProperty(value="subject")
    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public AuthorizationPolicy effect(EffectEnum effect) {
        this.effect = effect;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The effect this policy should have when its conditions are met")
    @JsonProperty(value="effect")
    public EffectEnum getEffect() {
        return this.effect;
    }

    public void setEffect(EffectEnum effect) {
        this.effect = effect;
    }

    public AuthorizationPolicy condition(Object condition) {
        this.condition = condition;
        return this;
    }

    @ApiModelProperty(example="null", value="The condition tree the policy will evaluate")
    @JsonProperty(value="condition")
    public Object getCondition() {
        return this.condition;
    }

    public void setCondition(Object condition) {
        this.condition = condition;
    }

    public AuthorizationPolicy description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(example="null", value="Date this policy was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public AuthorizationPolicy presetAttributes(Map<String, TypedAttribute> presetAttributes) {
        this.presetAttributes = presetAttributes;
        return this;
    }

    @ApiModelProperty(example="null", value="Map of names and values of preset attributes to use in policy evaluation")
    @JsonProperty(value="presetAttributes")
    public Map<String, TypedAttribute> getPresetAttributes() {
        return this.presetAttributes;
    }

    public void setPresetAttributes(Map<String, TypedAttribute> presetAttributes) {
        this.presetAttributes = presetAttributes;
    }

    public AuthorizationPolicy active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(example="null", value="Flag for active enforcement. If this value is false or null, the policy will be saved but will not be checked or enforced on users.")
    @JsonProperty(value="active")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationPolicy authorizationPolicy = (AuthorizationPolicy)o;
        return Objects.equals(this.id, authorizationPolicy.id) && Objects.equals(this.name, authorizationPolicy.name) && Objects.equals(this.targetResource, authorizationPolicy.targetResource) && Objects.equals(this.subject, authorizationPolicy.subject) && Objects.equals((Object)this.effect, (Object)authorizationPolicy.effect) && Objects.equals(this.condition, authorizationPolicy.condition) && Objects.equals(this.description, authorizationPolicy.description) && Objects.equals(this.dateModified, authorizationPolicy.dateModified) && Objects.equals(this.presetAttributes, authorizationPolicy.presetAttributes) && Objects.equals(this.active, authorizationPolicy.active) && Objects.equals(this.selfUri, authorizationPolicy.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.targetResource, this.subject, this.effect, this.condition, this.description, this.dateModified, this.presetAttributes, this.active, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthorizationPolicy {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    targetResource: ").append(this.toIndentedString(this.targetResource)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    effect: ").append(this.toIndentedString((Object)this.effect)).append("\n");
        sb.append("    condition: ").append(this.toIndentedString(this.condition)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    presetAttributes: ").append(this.toIndentedString(this.presetAttributes)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=EffectEnumDeserializer.class)
    public static enum EffectEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALLOW("ALLOW"),
        DENY("DENY");

        private String value;

        private EffectEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static EffectEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (EffectEnum value : EffectEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return EffectEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class EffectEnumDeserializer
    extends StdDeserializer<EffectEnum> {
        public EffectEnumDeserializer() {
            super(EffectEnumDeserializer.class);
        }

        public EffectEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return EffectEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

