/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.Operand;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class ConversationCategory
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private InteractionTypeEnum interactionType = null;
    private Operand criteria = null;

    public ConversationCategory id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the category")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ConversationCategory name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the category")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ConversationCategory description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of the category")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ConversationCategory interactionType(InteractionTypeEnum interactionType) {
        this.interactionType = interactionType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of interaction the category will apply to")
    @JsonProperty(value="interactionType")
    public InteractionTypeEnum getInteractionType() {
        return this.interactionType;
    }

    public void setInteractionType(InteractionTypeEnum interactionType) {
        this.interactionType = interactionType;
    }

    public ConversationCategory criteria(Operand criteria) {
        this.criteria = criteria;
        return this;
    }

    @ApiModelProperty(example="null", value="A collection of conditions joined together by logical operation to provide more refined filtering of conversations")
    @JsonProperty(value="criteria")
    public Operand getCriteria() {
        return this.criteria;
    }

    public void setCriteria(Operand criteria) {
        this.criteria = criteria;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationCategory conversationCategory = (ConversationCategory)o;
        return Objects.equals(this.id, conversationCategory.id) && Objects.equals(this.name, conversationCategory.name) && Objects.equals(this.description, conversationCategory.description) && Objects.equals((Object)this.interactionType, (Object)conversationCategory.interactionType) && Objects.equals(this.criteria, conversationCategory.criteria);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.interactionType, this.criteria});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationCategory {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    interactionType: ").append(this.toIndentedString((Object)this.interactionType)).append("\n");
        sb.append("    criteria: ").append(this.toIndentedString(this.criteria)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=InteractionTypeEnumDeserializer.class)
    public static enum InteractionTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        VOICE("Voice"),
        DIGITAL("Digital"),
        ALL("All");

        private String value;

        private InteractionTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static InteractionTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (InteractionTypeEnum value : InteractionTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return InteractionTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class InteractionTypeEnumDeserializer
    extends StdDeserializer<InteractionTypeEnum> {
        public InteractionTypeEnumDeserializer() {
            super(InteractionTypeEnumDeserializer.class);
        }

        public InteractionTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return InteractionTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

