/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AlternativeShiftAgentScheduledShift;
import com.mypurecloud.sdk.v2.model.AlternativeShiftScheduleLookup;
import com.mypurecloud.sdk.v2.model.ManagementUnitReference;
import com.mypurecloud.sdk.v2.model.UserReference;
import com.mypurecloud.sdk.v2.model.WfmVersionedEntityMetadata;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class AlternativeShiftTradeResponse
implements Serializable {
    private String id = null;
    private String shiftOfferJobId = null;
    private List<AlternativeShiftAgentScheduledShift> existingShifts = new ArrayList<AlternativeShiftAgentScheduledShift>();
    private List<AlternativeShiftAgentScheduledShift> offeredShifts = new ArrayList<AlternativeShiftAgentScheduledShift>();
    private AlternativeShiftScheduleLookup schedule = null;
    private ManagementUnitReference managementUnit = null;
    private UserReference user = null;
    private LocalDate weekDate = null;
    private Date expirationDate = null;
    private StateEnum state = null;
    private ProcessingStatusEnum processingStatus = null;
    private Date systemDateReviewed = null;
    private Date adminDateReviewed = null;
    private UserReference adminReviewedBy = null;
    private List<ViolationsEnum> violations = new ArrayList<ViolationsEnum>();
    private WfmVersionedEntityMetadata metadata = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public AlternativeShiftTradeResponse shiftOfferJobId(String shiftOfferJobId) {
        this.shiftOfferJobId = shiftOfferJobId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The job ID of the alternative shift offer listing, from which the trade was chosen")
    @JsonProperty(value="shiftOfferJobId")
    public String getShiftOfferJobId() {
        return this.shiftOfferJobId;
    }

    public void setShiftOfferJobId(String shiftOfferJobId) {
        this.shiftOfferJobId = shiftOfferJobId;
    }

    public AlternativeShiftTradeResponse existingShifts(List<AlternativeShiftAgentScheduledShift> existingShifts) {
        this.existingShifts = existingShifts;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The existing shifts from the offer, may be empty")
    @JsonProperty(value="existingShifts")
    public List<AlternativeShiftAgentScheduledShift> getExistingShifts() {
        return this.existingShifts;
    }

    public void setExistingShifts(List<AlternativeShiftAgentScheduledShift> existingShifts) {
        this.existingShifts = existingShifts;
    }

    public AlternativeShiftTradeResponse offeredShifts(List<AlternativeShiftAgentScheduledShift> offeredShifts) {
        this.offeredShifts = offeredShifts;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The offered shifts from the offer, may be empty")
    @JsonProperty(value="offeredShifts")
    public List<AlternativeShiftAgentScheduledShift> getOfferedShifts() {
        return this.offeredShifts;
    }

    public void setOfferedShifts(List<AlternativeShiftAgentScheduledShift> offeredShifts) {
        this.offeredShifts = offeredShifts;
    }

    public AlternativeShiftTradeResponse schedule(AlternativeShiftScheduleLookup schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The existing schedule information associated with the trade")
    @JsonProperty(value="schedule")
    public AlternativeShiftScheduleLookup getSchedule() {
        return this.schedule;
    }

    public void setSchedule(AlternativeShiftScheduleLookup schedule) {
        this.schedule = schedule;
    }

    public AlternativeShiftTradeResponse managementUnit(ManagementUnitReference managementUnit) {
        this.managementUnit = managementUnit;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The management unit of this alternative shift trade request")
    @JsonProperty(value="managementUnit")
    public ManagementUnitReference getManagementUnit() {
        return this.managementUnit;
    }

    public void setManagementUnit(ManagementUnitReference managementUnit) {
        this.managementUnit = managementUnit;
    }

    public AlternativeShiftTradeResponse user(UserReference user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The user who submitted the trade request")
    @JsonProperty(value="user")
    public UserReference getUser() {
        return this.user;
    }

    public void setUser(UserReference user) {
        this.user = user;
    }

    public AlternativeShiftTradeResponse weekDate(LocalDate weekDate) {
        this.weekDate = weekDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The start week date of the associated schedule in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="weekDate")
    public LocalDate getWeekDate() {
        return this.weekDate;
    }

    public void setWeekDate(LocalDate weekDate) {
        this.weekDate = weekDate;
    }

    public AlternativeShiftTradeResponse expirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The date when the trade will expire in ISO-8601 format. The trade cannot be approved after expiration")
    @JsonProperty(value="expirationDate")
    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public AlternativeShiftTradeResponse state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The state of this alternative shift trade")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public AlternativeShiftTradeResponse processingStatus(ProcessingStatusEnum processingStatus) {
        this.processingStatus = processingStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="The processing status of this alternative shift trade")
    @JsonProperty(value="processingStatus")
    public ProcessingStatusEnum getProcessingStatus() {
        return this.processingStatus;
    }

    public void setProcessingStatus(ProcessingStatusEnum processingStatus) {
        this.processingStatus = processingStatus;
    }

    public AlternativeShiftTradeResponse systemDateReviewed(Date systemDateReviewed) {
        this.systemDateReviewed = systemDateReviewed;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp of when the trade request was reviewed by the system in ISO-8601 format")
    @JsonProperty(value="systemDateReviewed")
    public Date getSystemDateReviewed() {
        return this.systemDateReviewed;
    }

    public void setSystemDateReviewed(Date systemDateReviewed) {
        this.systemDateReviewed = systemDateReviewed;
    }

    public AlternativeShiftTradeResponse adminDateReviewed(Date adminDateReviewed) {
        this.adminDateReviewed = adminDateReviewed;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp of when the trade request was reviewed by an admin in ISO-8601 format")
    @JsonProperty(value="adminDateReviewed")
    public Date getAdminDateReviewed() {
        return this.adminDateReviewed;
    }

    public void setAdminDateReviewed(Date adminDateReviewed) {
        this.adminDateReviewed = adminDateReviewed;
    }

    public AlternativeShiftTradeResponse adminReviewedBy(UserReference adminReviewedBy) {
        this.adminReviewedBy = adminReviewedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The admin who reviewed this alternative shift trade after system denial")
    @JsonProperty(value="adminReviewedBy")
    public UserReference getAdminReviewedBy() {
        return this.adminReviewedBy;
    }

    public void setAdminReviewedBy(UserReference adminReviewedBy) {
        this.adminReviewedBy = adminReviewedBy;
    }

    public AlternativeShiftTradeResponse violations(List<ViolationsEnum> violations) {
        this.violations = violations;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A list of trade match violations")
    @JsonProperty(value="violations")
    public List<ViolationsEnum> getViolations() {
        return this.violations;
    }

    public void setViolations(List<ViolationsEnum> violations) {
        this.violations = violations;
    }

    public AlternativeShiftTradeResponse metadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Version metadata for this alternative shift trade")
    @JsonProperty(value="metadata")
    public WfmVersionedEntityMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlternativeShiftTradeResponse alternativeShiftTradeResponse = (AlternativeShiftTradeResponse)o;
        return Objects.equals(this.id, alternativeShiftTradeResponse.id) && Objects.equals(this.shiftOfferJobId, alternativeShiftTradeResponse.shiftOfferJobId) && Objects.equals(this.existingShifts, alternativeShiftTradeResponse.existingShifts) && Objects.equals(this.offeredShifts, alternativeShiftTradeResponse.offeredShifts) && Objects.equals(this.schedule, alternativeShiftTradeResponse.schedule) && Objects.equals(this.managementUnit, alternativeShiftTradeResponse.managementUnit) && Objects.equals(this.user, alternativeShiftTradeResponse.user) && Objects.equals(this.weekDate, alternativeShiftTradeResponse.weekDate) && Objects.equals(this.expirationDate, alternativeShiftTradeResponse.expirationDate) && Objects.equals((Object)this.state, (Object)alternativeShiftTradeResponse.state) && Objects.equals((Object)this.processingStatus, (Object)alternativeShiftTradeResponse.processingStatus) && Objects.equals(this.systemDateReviewed, alternativeShiftTradeResponse.systemDateReviewed) && Objects.equals(this.adminDateReviewed, alternativeShiftTradeResponse.adminDateReviewed) && Objects.equals(this.adminReviewedBy, alternativeShiftTradeResponse.adminReviewedBy) && Objects.equals(this.violations, alternativeShiftTradeResponse.violations) && Objects.equals(this.metadata, alternativeShiftTradeResponse.metadata) && Objects.equals(this.selfUri, alternativeShiftTradeResponse.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.shiftOfferJobId, this.existingShifts, this.offeredShifts, this.schedule, this.managementUnit, this.user, this.weekDate, this.expirationDate, this.state, this.processingStatus, this.systemDateReviewed, this.adminDateReviewed, this.adminReviewedBy, this.violations, this.metadata, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlternativeShiftTradeResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    shiftOfferJobId: ").append(this.toIndentedString(this.shiftOfferJobId)).append("\n");
        sb.append("    existingShifts: ").append(this.toIndentedString(this.existingShifts)).append("\n");
        sb.append("    offeredShifts: ").append(this.toIndentedString(this.offeredShifts)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    managementUnit: ").append(this.toIndentedString(this.managementUnit)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    weekDate: ").append(this.toIndentedString(this.weekDate)).append("\n");
        sb.append("    expirationDate: ").append(this.toIndentedString(this.expirationDate)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    processingStatus: ").append(this.toIndentedString((Object)this.processingStatus)).append("\n");
        sb.append("    systemDateReviewed: ").append(this.toIndentedString(this.systemDateReviewed)).append("\n");
        sb.append("    adminDateReviewed: ").append(this.toIndentedString(this.adminDateReviewed)).append("\n");
        sb.append("    adminReviewedBy: ").append(this.toIndentedString(this.adminReviewedBy)).append("\n");
        sb.append("    violations: ").append(this.toIndentedString(this.violations)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CANCELED("Canceled"),
        DENIED("Denied"),
        EXPIRED("Expired"),
        SUBMITTED("Submitted"),
        APPROVED("Approved");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ProcessingStatusEnumDeserializer.class)
    public static enum ProcessingStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ERROR("Error"),
        WAITINGFORSCHEDULEUPDATE("WaitingForScheduleUpdate"),
        SCHEDULEUPDATING("ScheduleUpdating"),
        SCHEDULEUPDATED("ScheduleUpdated"),
        WAITINGFORREVIEW("WaitingForReview"),
        REVIEWING("Reviewing");

        private String value;

        private ProcessingStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ProcessingStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ProcessingStatusEnum value : ProcessingStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ProcessingStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ViolationsEnumDeserializer.class)
    public static enum ViolationsEnum {
        SERVICEGOALSNOTMET("ServiceGoalsNotMet");

        private String value;

        private ViolationsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ViolationsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ViolationsEnum value : ViolationsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ViolationsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ViolationsEnumDeserializer
    extends StdDeserializer<ViolationsEnum> {
        public ViolationsEnumDeserializer() {
            super(ViolationsEnumDeserializer.class);
        }

        public ViolationsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ViolationsEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class ProcessingStatusEnumDeserializer
    extends StdDeserializer<ProcessingStatusEnum> {
        public ProcessingStatusEnumDeserializer() {
            super(ProcessingStatusEnumDeserializer.class);
        }

        public ProcessingStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ProcessingStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

