/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.KnowledgeDocumentBulkRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PatchKnowledgeKnowledgebaseLanguageDocumentsRequest {
    private String knowledgeBaseId;
    private String languageCode;
    private List<KnowledgeDocumentBulkRequest> body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public void setKnowledgeBaseId(String knowledgeBaseId) {
        this.knowledgeBaseId = knowledgeBaseId;
    }

    public PatchKnowledgeKnowledgebaseLanguageDocumentsRequest withKnowledgeBaseId(String knowledgeBaseId) {
        this.setKnowledgeBaseId(knowledgeBaseId);
        return this;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public PatchKnowledgeKnowledgebaseLanguageDocumentsRequest withLanguageCode(String languageCode) {
        this.setLanguageCode(languageCode);
        return this;
    }

    public List<KnowledgeDocumentBulkRequest> getBody() {
        return this.body;
    }

    public void setBody(List<KnowledgeDocumentBulkRequest> body) {
        this.body = body;
    }

    public PatchKnowledgeKnowledgebaseLanguageDocumentsRequest withBody(List<KnowledgeDocumentBulkRequest> body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchKnowledgeKnowledgebaseLanguageDocumentsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<List<KnowledgeDocumentBulkRequest>> withHttpInfo() {
        if (this.knowledgeBaseId == null) {
            throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PatchKnowledgeKnowledgebaseLanguageDocumentsRequest.");
        }
        if (this.languageCode == null) {
            throw new IllegalStateException("Missing the required parameter 'languageCode' when building request for PatchKnowledgeKnowledgebaseLanguageDocumentsRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchKnowledgeKnowledgebaseLanguageDocumentsRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/documents").withPathParameter("knowledgeBaseId", this.knowledgeBaseId).withPathParameter("languageCode", this.languageCode).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String knowledgeBaseId, String languageCode, List<KnowledgeDocumentBulkRequest> body) {
        return new Builder().withRequiredParams(knowledgeBaseId, languageCode, body);
    }

    public static class Builder {
        private final PatchKnowledgeKnowledgebaseLanguageDocumentsRequest request = new PatchKnowledgeKnowledgebaseLanguageDocumentsRequest();

        private Builder() {
        }

        public Builder withKnowledgeBaseId(String knowledgeBaseId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            return this;
        }

        public Builder withLanguageCode(String languageCode) {
            this.request.setLanguageCode(languageCode);
            return this;
        }

        public Builder withLanguageCode(languageCodeValues languageCode) {
            this.request.setLanguageCode(languageCode.toString());
            return this;
        }

        public Builder withBody(List<KnowledgeDocumentBulkRequest> body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String knowledgeBaseId, String languageCode, List<KnowledgeDocumentBulkRequest> body) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            this.request.setLanguageCode(languageCode);
            this.request.setBody(body);
            return this;
        }

        public PatchKnowledgeKnowledgebaseLanguageDocumentsRequest build() {
            if (this.request.knowledgeBaseId == null) {
                throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PatchKnowledgeKnowledgebaseLanguageDocumentsRequest.");
            }
            if (this.request.languageCode == null) {
                throw new IllegalStateException("Missing the required parameter 'languageCode' when building request for PatchKnowledgeKnowledgebaseLanguageDocumentsRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchKnowledgeKnowledgebaseLanguageDocumentsRequest.");
            }
            return this.request;
        }
    }

    public static enum languageCodeValues {
        EN_US("en-US"),
        EN_UK("en-UK"),
        EN_AU("en-AU"),
        EN_CA("en-CA"),
        EN_HK("en-HK"),
        EN_IN("en-IN"),
        EN_IE("en-IE"),
        EN_NZ("en-NZ"),
        EN_PH("en-PH"),
        EN_SG("en-SG"),
        EN_ZA("en-ZA"),
        DE_DE("de-DE"),
        DE_AT("de-AT"),
        DE_CH("de-CH"),
        ES_AR("es-AR"),
        ES_CO("es-CO"),
        ES_MX("es-MX"),
        ES_US("es-US"),
        ES_ES("es-ES"),
        FR_FR("fr-FR"),
        FR_BE("fr-BE"),
        FR_CA("fr-CA"),
        FR_CH("fr-CH"),
        PT_BR("pt-BR"),
        PT_PT("pt-PT"),
        NL_NL("nl-NL"),
        NL_BE("nl-BE"),
        IT_IT("it-IT"),
        CA_ES("ca-ES"),
        TR_TR("tr-TR"),
        SV_SE("sv-SE"),
        FI_FI("fi-FI"),
        NB_NO("nb-NO"),
        DA_DK("da-DK"),
        JA_JP("ja-JP"),
        AR_AE("ar-AE"),
        ZH_CN("zh-CN"),
        ZH_TW("zh-TW"),
        ZH_HK("zh-HK"),
        KO_KR("ko-KR"),
        PL_PL("pl-PL"),
        HI_IN("hi-IN"),
        TH_TH("th-TH"),
        HU_HU("hu-HU"),
        VI_VN("vi-VN"),
        UK_UA("uk-UA");

        private String value;

        private languageCodeValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static languageCodeValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (languageCodeValues value : languageCodeValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return languageCodeValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

