/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Button response object representing the click of a structured message button, such as a quick reply.")
public class ConversationContentButtonResponse
implements Serializable {
    private TypeEnum type = null;
    private String text = null;
    private String payload = null;

    public ConversationContentButtonResponse type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="Describes the button that resulted in the Button Response.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ConversationContentButtonResponse text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The response text from the button click.")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public ConversationContentButtonResponse payload(String payload) {
        this.payload = payload;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The response payload associated with the clicked button.")
    @JsonProperty(value="payload")
    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationContentButtonResponse conversationContentButtonResponse = (ConversationContentButtonResponse)o;
        return Objects.equals((Object)this.type, (Object)conversationContentButtonResponse.type) && Objects.equals(this.text, conversationContentButtonResponse.text) && Objects.equals(this.payload, conversationContentButtonResponse.payload);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.text, this.payload});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationContentButtonResponse {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BUTTON("Button"),
        QUICKREPLY("QuickReply"),
        DATEPICKER("DatePicker");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

