/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteWebchatDeploymentRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteWebchatGuestConversationMemberRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteWebchatSettingsRequest;
import com.mypurecloud.sdk.v2.api.request.GetWebchatDeploymentRequest;
import com.mypurecloud.sdk.v2.api.request.GetWebchatDeploymentsRequest;
import com.mypurecloud.sdk.v2.api.request.GetWebchatGuestConversationMediarequestRequest;
import com.mypurecloud.sdk.v2.api.request.GetWebchatGuestConversationMediarequestsRequest;
import com.mypurecloud.sdk.v2.api.request.GetWebchatGuestConversationMemberRequest;
import com.mypurecloud.sdk.v2.api.request.GetWebchatGuestConversationMembersRequest;
import com.mypurecloud.sdk.v2.api.request.GetWebchatGuestConversationMessageRequest;
import com.mypurecloud.sdk.v2.api.request.GetWebchatGuestConversationMessagesRequest;
import com.mypurecloud.sdk.v2.api.request.GetWebchatSettingsRequest;
import com.mypurecloud.sdk.v2.api.request.PatchWebchatGuestConversationMediarequestRequest;
import com.mypurecloud.sdk.v2.api.request.PostWebchatDeploymentsRequest;
import com.mypurecloud.sdk.v2.api.request.PostWebchatGuestConversationMemberMessagesRequest;
import com.mypurecloud.sdk.v2.api.request.PostWebchatGuestConversationMemberTypingRequest;
import com.mypurecloud.sdk.v2.api.request.PostWebchatGuestConversationsRequest;
import com.mypurecloud.sdk.v2.api.request.PutWebchatDeploymentRequest;
import com.mypurecloud.sdk.v2.api.request.PutWebchatSettingsRequest;
import com.mypurecloud.sdk.v2.model.CreateWebChatConversationRequest;
import com.mypurecloud.sdk.v2.model.CreateWebChatConversationResponse;
import com.mypurecloud.sdk.v2.model.CreateWebChatMessageRequest;
import com.mypurecloud.sdk.v2.model.WebChatDeployment;
import com.mypurecloud.sdk.v2.model.WebChatDeploymentEntityListing;
import com.mypurecloud.sdk.v2.model.WebChatGuestMediaRequest;
import com.mypurecloud.sdk.v2.model.WebChatGuestMediaRequestEntityList;
import com.mypurecloud.sdk.v2.model.WebChatMemberInfo;
import com.mypurecloud.sdk.v2.model.WebChatMemberInfoEntityList;
import com.mypurecloud.sdk.v2.model.WebChatMessage;
import com.mypurecloud.sdk.v2.model.WebChatMessageEntityList;
import com.mypurecloud.sdk.v2.model.WebChatSettings;
import com.mypurecloud.sdk.v2.model.WebChatTyping;
import java.io.IOException;

public class WebChatApi {
    private final ApiClient pcapiClient;

    public WebChatApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WebChatApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteWebchatDeployment(String deploymentId) throws IOException, ApiException {
        this.deleteWebchatDeployment(this.createDeleteWebchatDeploymentRequest(deploymentId));
    }

    public ApiResponse<Void> deleteWebchatDeploymentWithHttpInfo(String deploymentId) throws IOException {
        return this.deleteWebchatDeployment(this.createDeleteWebchatDeploymentRequest(deploymentId).withHttpInfo());
    }

    private DeleteWebchatDeploymentRequest createDeleteWebchatDeploymentRequest(String deploymentId) {
        return DeleteWebchatDeploymentRequest.builder().withDeploymentId(deploymentId).build();
    }

    public void deleteWebchatDeployment(DeleteWebchatDeploymentRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteWebchatDeployment(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public void deleteWebchatGuestConversationMember(String conversationId, String memberId) throws IOException, ApiException {
        this.deleteWebchatGuestConversationMember(this.createDeleteWebchatGuestConversationMemberRequest(conversationId, memberId));
    }

    public ApiResponse<Void> deleteWebchatGuestConversationMemberWithHttpInfo(String conversationId, String memberId) throws IOException {
        return this.deleteWebchatGuestConversationMember(this.createDeleteWebchatGuestConversationMemberRequest(conversationId, memberId).withHttpInfo());
    }

    private DeleteWebchatGuestConversationMemberRequest createDeleteWebchatGuestConversationMemberRequest(String conversationId, String memberId) {
        return DeleteWebchatGuestConversationMemberRequest.builder().withConversationId(conversationId).withMemberId(memberId).build();
    }

    public void deleteWebchatGuestConversationMember(DeleteWebchatGuestConversationMemberRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteWebchatGuestConversationMember(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public void deleteWebchatSettings() throws IOException, ApiException {
        this.deleteWebchatSettings(this.createDeleteWebchatSettingsRequest());
    }

    public ApiResponse<Void> deleteWebchatSettingsWithHttpInfo() throws IOException {
        return this.deleteWebchatSettings(this.createDeleteWebchatSettingsRequest().withHttpInfo());
    }

    private DeleteWebchatSettingsRequest createDeleteWebchatSettingsRequest() {
        return DeleteWebchatSettingsRequest.builder().build();
    }

    public void deleteWebchatSettings(DeleteWebchatSettingsRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteWebchatSettings(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WebChatDeployment getWebchatDeployment(String deploymentId) throws IOException, ApiException {
        return this.getWebchatDeployment(this.createGetWebchatDeploymentRequest(deploymentId));
    }

    public ApiResponse<WebChatDeployment> getWebchatDeploymentWithHttpInfo(String deploymentId) throws IOException {
        return this.getWebchatDeployment(this.createGetWebchatDeploymentRequest(deploymentId).withHttpInfo());
    }

    private GetWebchatDeploymentRequest createGetWebchatDeploymentRequest(String deploymentId) {
        return GetWebchatDeploymentRequest.builder().withDeploymentId(deploymentId).build();
    }

    public WebChatDeployment getWebchatDeployment(GetWebchatDeploymentRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WebChatDeployment> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WebChatDeployment>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WebChatDeployment> getWebchatDeployment(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WebChatDeployment>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WebChatDeploymentEntityListing getWebchatDeployments() throws IOException, ApiException {
        return this.getWebchatDeployments(this.createGetWebchatDeploymentsRequest());
    }

    public ApiResponse<WebChatDeploymentEntityListing> getWebchatDeploymentsWithHttpInfo() throws IOException {
        return this.getWebchatDeployments(this.createGetWebchatDeploymentsRequest().withHttpInfo());
    }

    private GetWebchatDeploymentsRequest createGetWebchatDeploymentsRequest() {
        return GetWebchatDeploymentsRequest.builder().build();
    }

    public WebChatDeploymentEntityListing getWebchatDeployments(GetWebchatDeploymentsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WebChatDeploymentEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WebChatDeploymentEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WebChatDeploymentEntityListing> getWebchatDeployments(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WebChatDeploymentEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WebChatGuestMediaRequest getWebchatGuestConversationMediarequest(String conversationId, String mediaRequestId) throws IOException, ApiException {
        return this.getWebchatGuestConversationMediarequest(this.createGetWebchatGuestConversationMediarequestRequest(conversationId, mediaRequestId));
    }

    public ApiResponse<WebChatGuestMediaRequest> getWebchatGuestConversationMediarequestWithHttpInfo(String conversationId, String mediaRequestId) throws IOException {
        return this.getWebchatGuestConversationMediarequest(this.createGetWebchatGuestConversationMediarequestRequest(conversationId, mediaRequestId).withHttpInfo());
    }

    private GetWebchatGuestConversationMediarequestRequest createGetWebchatGuestConversationMediarequestRequest(String conversationId, String mediaRequestId) {
        return GetWebchatGuestConversationMediarequestRequest.builder().withConversationId(conversationId).withMediaRequestId(mediaRequestId).build();
    }

    public WebChatGuestMediaRequest getWebchatGuestConversationMediarequest(GetWebchatGuestConversationMediarequestRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WebChatGuestMediaRequest> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WebChatGuestMediaRequest>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WebChatGuestMediaRequest> getWebchatGuestConversationMediarequest(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WebChatGuestMediaRequest>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WebChatGuestMediaRequestEntityList getWebchatGuestConversationMediarequests(String conversationId) throws IOException, ApiException {
        return this.getWebchatGuestConversationMediarequests(this.createGetWebchatGuestConversationMediarequestsRequest(conversationId));
    }

    public ApiResponse<WebChatGuestMediaRequestEntityList> getWebchatGuestConversationMediarequestsWithHttpInfo(String conversationId) throws IOException {
        return this.getWebchatGuestConversationMediarequests(this.createGetWebchatGuestConversationMediarequestsRequest(conversationId).withHttpInfo());
    }

    private GetWebchatGuestConversationMediarequestsRequest createGetWebchatGuestConversationMediarequestsRequest(String conversationId) {
        return GetWebchatGuestConversationMediarequestsRequest.builder().withConversationId(conversationId).build();
    }

    public WebChatGuestMediaRequestEntityList getWebchatGuestConversationMediarequests(GetWebchatGuestConversationMediarequestsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WebChatGuestMediaRequestEntityList> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WebChatGuestMediaRequestEntityList>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WebChatGuestMediaRequestEntityList> getWebchatGuestConversationMediarequests(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WebChatGuestMediaRequestEntityList>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WebChatMemberInfo getWebchatGuestConversationMember(String conversationId, String memberId) throws IOException, ApiException {
        return this.getWebchatGuestConversationMember(this.createGetWebchatGuestConversationMemberRequest(conversationId, memberId));
    }

    public ApiResponse<WebChatMemberInfo> getWebchatGuestConversationMemberWithHttpInfo(String conversationId, String memberId) throws IOException {
        return this.getWebchatGuestConversationMember(this.createGetWebchatGuestConversationMemberRequest(conversationId, memberId).withHttpInfo());
    }

    private GetWebchatGuestConversationMemberRequest createGetWebchatGuestConversationMemberRequest(String conversationId, String memberId) {
        return GetWebchatGuestConversationMemberRequest.builder().withConversationId(conversationId).withMemberId(memberId).build();
    }

    public WebChatMemberInfo getWebchatGuestConversationMember(GetWebchatGuestConversationMemberRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WebChatMemberInfo> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WebChatMemberInfo>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WebChatMemberInfo> getWebchatGuestConversationMember(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WebChatMemberInfo>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WebChatMemberInfoEntityList getWebchatGuestConversationMembers(String conversationId, Integer pageSize, Integer pageNumber, Boolean excludeDisconnectedMembers) throws IOException, ApiException {
        return this.getWebchatGuestConversationMembers(this.createGetWebchatGuestConversationMembersRequest(conversationId, pageSize, pageNumber, excludeDisconnectedMembers));
    }

    public ApiResponse<WebChatMemberInfoEntityList> getWebchatGuestConversationMembersWithHttpInfo(String conversationId, Integer pageSize, Integer pageNumber, Boolean excludeDisconnectedMembers) throws IOException {
        return this.getWebchatGuestConversationMembers(this.createGetWebchatGuestConversationMembersRequest(conversationId, pageSize, pageNumber, excludeDisconnectedMembers).withHttpInfo());
    }

    private GetWebchatGuestConversationMembersRequest createGetWebchatGuestConversationMembersRequest(String conversationId, Integer pageSize, Integer pageNumber, Boolean excludeDisconnectedMembers) {
        return GetWebchatGuestConversationMembersRequest.builder().withConversationId(conversationId).withPageSize(pageSize).withPageNumber(pageNumber).withExcludeDisconnectedMembers(excludeDisconnectedMembers).build();
    }

    public WebChatMemberInfoEntityList getWebchatGuestConversationMembers(GetWebchatGuestConversationMembersRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WebChatMemberInfoEntityList> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WebChatMemberInfoEntityList>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WebChatMemberInfoEntityList> getWebchatGuestConversationMembers(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WebChatMemberInfoEntityList>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WebChatMessage getWebchatGuestConversationMessage(String conversationId, String messageId) throws IOException, ApiException {
        return this.getWebchatGuestConversationMessage(this.createGetWebchatGuestConversationMessageRequest(conversationId, messageId));
    }

    public ApiResponse<WebChatMessage> getWebchatGuestConversationMessageWithHttpInfo(String conversationId, String messageId) throws IOException {
        return this.getWebchatGuestConversationMessage(this.createGetWebchatGuestConversationMessageRequest(conversationId, messageId).withHttpInfo());
    }

    private GetWebchatGuestConversationMessageRequest createGetWebchatGuestConversationMessageRequest(String conversationId, String messageId) {
        return GetWebchatGuestConversationMessageRequest.builder().withConversationId(conversationId).withMessageId(messageId).build();
    }

    public WebChatMessage getWebchatGuestConversationMessage(GetWebchatGuestConversationMessageRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WebChatMessage> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WebChatMessage>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WebChatMessage> getWebchatGuestConversationMessage(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WebChatMessage>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WebChatMessageEntityList getWebchatGuestConversationMessages(String conversationId, String after, String before, String sortOrder, Integer maxResults) throws IOException, ApiException {
        return this.getWebchatGuestConversationMessages(this.createGetWebchatGuestConversationMessagesRequest(conversationId, after, before, sortOrder, maxResults));
    }

    public ApiResponse<WebChatMessageEntityList> getWebchatGuestConversationMessagesWithHttpInfo(String conversationId, String after, String before, String sortOrder, Integer maxResults) throws IOException {
        return this.getWebchatGuestConversationMessages(this.createGetWebchatGuestConversationMessagesRequest(conversationId, after, before, sortOrder, maxResults).withHttpInfo());
    }

    private GetWebchatGuestConversationMessagesRequest createGetWebchatGuestConversationMessagesRequest(String conversationId, String after, String before, String sortOrder, Integer maxResults) {
        return GetWebchatGuestConversationMessagesRequest.builder().withConversationId(conversationId).withAfter(after).withBefore(before).withSortOrder(sortOrder).withMaxResults(maxResults).build();
    }

    public WebChatMessageEntityList getWebchatGuestConversationMessages(GetWebchatGuestConversationMessagesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WebChatMessageEntityList> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WebChatMessageEntityList>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WebChatMessageEntityList> getWebchatGuestConversationMessages(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WebChatMessageEntityList>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WebChatSettings getWebchatSettings() throws IOException, ApiException {
        return this.getWebchatSettings(this.createGetWebchatSettingsRequest());
    }

    public ApiResponse<WebChatSettings> getWebchatSettingsWithHttpInfo() throws IOException {
        return this.getWebchatSettings(this.createGetWebchatSettingsRequest().withHttpInfo());
    }

    private GetWebchatSettingsRequest createGetWebchatSettingsRequest() {
        return GetWebchatSettingsRequest.builder().build();
    }

    public WebChatSettings getWebchatSettings(GetWebchatSettingsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WebChatSettings> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WebChatSettings>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WebChatSettings> getWebchatSettings(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WebChatSettings>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WebChatGuestMediaRequest patchWebchatGuestConversationMediarequest(String conversationId, String mediaRequestId, WebChatGuestMediaRequest body) throws IOException, ApiException {
        return this.patchWebchatGuestConversationMediarequest(this.createPatchWebchatGuestConversationMediarequestRequest(conversationId, mediaRequestId, body));
    }

    public ApiResponse<WebChatGuestMediaRequest> patchWebchatGuestConversationMediarequestWithHttpInfo(String conversationId, String mediaRequestId, WebChatGuestMediaRequest body) throws IOException {
        return this.patchWebchatGuestConversationMediarequest(this.createPatchWebchatGuestConversationMediarequestRequest(conversationId, mediaRequestId, body).withHttpInfo());
    }

    private PatchWebchatGuestConversationMediarequestRequest createPatchWebchatGuestConversationMediarequestRequest(String conversationId, String mediaRequestId, WebChatGuestMediaRequest body) {
        return PatchWebchatGuestConversationMediarequestRequest.builder().withConversationId(conversationId).withMediaRequestId(mediaRequestId).withBody(body).build();
    }

    public WebChatGuestMediaRequest patchWebchatGuestConversationMediarequest(PatchWebchatGuestConversationMediarequestRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WebChatGuestMediaRequest> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WebChatGuestMediaRequest>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WebChatGuestMediaRequest> patchWebchatGuestConversationMediarequest(ApiRequest<WebChatGuestMediaRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WebChatGuestMediaRequest>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WebChatDeployment postWebchatDeployments(WebChatDeployment body) throws IOException, ApiException {
        return this.postWebchatDeployments(this.createPostWebchatDeploymentsRequest(body));
    }

    public ApiResponse<WebChatDeployment> postWebchatDeploymentsWithHttpInfo(WebChatDeployment body) throws IOException {
        return this.postWebchatDeployments(this.createPostWebchatDeploymentsRequest(body).withHttpInfo());
    }

    private PostWebchatDeploymentsRequest createPostWebchatDeploymentsRequest(WebChatDeployment body) {
        return PostWebchatDeploymentsRequest.builder().withBody(body).build();
    }

    public WebChatDeployment postWebchatDeployments(PostWebchatDeploymentsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WebChatDeployment> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WebChatDeployment>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WebChatDeployment> postWebchatDeployments(ApiRequest<WebChatDeployment> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WebChatDeployment>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WebChatMessage postWebchatGuestConversationMemberMessages(String conversationId, String memberId, CreateWebChatMessageRequest body) throws IOException, ApiException {
        return this.postWebchatGuestConversationMemberMessages(this.createPostWebchatGuestConversationMemberMessagesRequest(conversationId, memberId, body));
    }

    public ApiResponse<WebChatMessage> postWebchatGuestConversationMemberMessagesWithHttpInfo(String conversationId, String memberId, CreateWebChatMessageRequest body) throws IOException {
        return this.postWebchatGuestConversationMemberMessages(this.createPostWebchatGuestConversationMemberMessagesRequest(conversationId, memberId, body).withHttpInfo());
    }

    private PostWebchatGuestConversationMemberMessagesRequest createPostWebchatGuestConversationMemberMessagesRequest(String conversationId, String memberId, CreateWebChatMessageRequest body) {
        return PostWebchatGuestConversationMemberMessagesRequest.builder().withConversationId(conversationId).withMemberId(memberId).withBody(body).build();
    }

    public WebChatMessage postWebchatGuestConversationMemberMessages(PostWebchatGuestConversationMemberMessagesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WebChatMessage> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WebChatMessage>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WebChatMessage> postWebchatGuestConversationMemberMessages(ApiRequest<CreateWebChatMessageRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WebChatMessage>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WebChatTyping postWebchatGuestConversationMemberTyping(String conversationId, String memberId) throws IOException, ApiException {
        return this.postWebchatGuestConversationMemberTyping(this.createPostWebchatGuestConversationMemberTypingRequest(conversationId, memberId));
    }

    public ApiResponse<WebChatTyping> postWebchatGuestConversationMemberTypingWithHttpInfo(String conversationId, String memberId) throws IOException {
        return this.postWebchatGuestConversationMemberTyping(this.createPostWebchatGuestConversationMemberTypingRequest(conversationId, memberId).withHttpInfo());
    }

    private PostWebchatGuestConversationMemberTypingRequest createPostWebchatGuestConversationMemberTypingRequest(String conversationId, String memberId) {
        return PostWebchatGuestConversationMemberTypingRequest.builder().withConversationId(conversationId).withMemberId(memberId).build();
    }

    public WebChatTyping postWebchatGuestConversationMemberTyping(PostWebchatGuestConversationMemberTypingRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WebChatTyping> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WebChatTyping>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WebChatTyping> postWebchatGuestConversationMemberTyping(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WebChatTyping>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CreateWebChatConversationResponse postWebchatGuestConversations(CreateWebChatConversationRequest body) throws IOException, ApiException {
        return this.postWebchatGuestConversations(this.createPostWebchatGuestConversationsRequest(body));
    }

    public ApiResponse<CreateWebChatConversationResponse> postWebchatGuestConversationsWithHttpInfo(CreateWebChatConversationRequest body) throws IOException {
        return this.postWebchatGuestConversations(this.createPostWebchatGuestConversationsRequest(body).withHttpInfo());
    }

    private PostWebchatGuestConversationsRequest createPostWebchatGuestConversationsRequest(CreateWebChatConversationRequest body) {
        return PostWebchatGuestConversationsRequest.builder().withBody(body).build();
    }

    public CreateWebChatConversationResponse postWebchatGuestConversations(PostWebchatGuestConversationsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CreateWebChatConversationResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CreateWebChatConversationResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CreateWebChatConversationResponse> postWebchatGuestConversations(ApiRequest<CreateWebChatConversationRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CreateWebChatConversationResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WebChatDeployment putWebchatDeployment(String deploymentId, WebChatDeployment body) throws IOException, ApiException {
        return this.putWebchatDeployment(this.createPutWebchatDeploymentRequest(deploymentId, body));
    }

    public ApiResponse<WebChatDeployment> putWebchatDeploymentWithHttpInfo(String deploymentId, WebChatDeployment body) throws IOException {
        return this.putWebchatDeployment(this.createPutWebchatDeploymentRequest(deploymentId, body).withHttpInfo());
    }

    private PutWebchatDeploymentRequest createPutWebchatDeploymentRequest(String deploymentId, WebChatDeployment body) {
        return PutWebchatDeploymentRequest.builder().withDeploymentId(deploymentId).withBody(body).build();
    }

    public WebChatDeployment putWebchatDeployment(PutWebchatDeploymentRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WebChatDeployment> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WebChatDeployment>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WebChatDeployment> putWebchatDeployment(ApiRequest<WebChatDeployment> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WebChatDeployment>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WebChatSettings putWebchatSettings(WebChatSettings body) throws IOException, ApiException {
        return this.putWebchatSettings(this.createPutWebchatSettingsRequest(body));
    }

    public ApiResponse<WebChatSettings> putWebchatSettingsWithHttpInfo(WebChatSettings body) throws IOException {
        return this.putWebchatSettings(this.createPutWebchatSettingsRequest(body).withHttpInfo());
    }

    private PutWebchatSettingsRequest createPutWebchatSettingsRequest(WebChatSettings body) {
        return PutWebchatSettingsRequest.builder().withBody(body).build();
    }

    public WebChatSettings putWebchatSettings(PutWebchatSettingsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WebChatSettings> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WebChatSettings>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WebChatSettings> putWebchatSettings(ApiRequest<WebChatSettings> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WebChatSettings>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

