/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.FlowPathsFlowDetails;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FlowPathsElement
implements Serializable {
    private String parentId = null;
    private TypeEnum type = null;
    private Integer count = null;
    private List<FlowPathsFlowDetails> flows = new ArrayList<FlowPathsFlowDetails>();
    private FlowOutcomeValueEnum flowOutcomeValue = null;
    private AddressableEntityRef flowMilestone = null;
    private AddressableEntityRef flowOutcome = null;

    public FlowPathsElement parentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier of the parent element. Will be null for the root element.")
    @JsonProperty(value="parentId")
    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public FlowPathsElement type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Type of the element.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public FlowPathsElement count(Integer count) {
        this.count = count;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Count of all journeys that include this element.")
    @JsonProperty(value="count")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public FlowPathsElement flows(List<FlowPathsFlowDetails> flows) {
        this.flows = flows;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Details of flows involved in journeys that include this element.")
    @JsonProperty(value="flows")
    public List<FlowPathsFlowDetails> getFlows() {
        return this.flows;
    }

    public void setFlows(List<FlowPathsFlowDetails> flows) {
        this.flows = flows;
    }

    public FlowPathsElement flowOutcomeValue(FlowOutcomeValueEnum flowOutcomeValue) {
        this.flowOutcomeValue = flowOutcomeValue;
        return this;
    }

    @ApiModelProperty(example="null", value="The value of the flow outcome, if the element type is Outcome.")
    @JsonProperty(value="flowOutcomeValue")
    public FlowOutcomeValueEnum getFlowOutcomeValue() {
        return this.flowOutcomeValue;
    }

    public void setFlowOutcomeValue(FlowOutcomeValueEnum flowOutcomeValue) {
        this.flowOutcomeValue = flowOutcomeValue;
    }

    @ApiModelProperty(example="null", value="The flow milestone, set if the element type is Milestone.")
    @JsonProperty(value="flowMilestone")
    public AddressableEntityRef getFlowMilestone() {
        return this.flowMilestone;
    }

    @ApiModelProperty(example="null", value="The flow outcome, set if the element type is Outcome or Milestone.")
    @JsonProperty(value="flowOutcome")
    public AddressableEntityRef getFlowOutcome() {
        return this.flowOutcome;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowPathsElement flowPathsElement = (FlowPathsElement)o;
        return Objects.equals(this.parentId, flowPathsElement.parentId) && Objects.equals((Object)this.type, (Object)flowPathsElement.type) && Objects.equals(this.count, flowPathsElement.count) && Objects.equals(this.flows, flowPathsElement.flows) && Objects.equals((Object)this.flowOutcomeValue, (Object)flowPathsElement.flowOutcomeValue) && Objects.equals(this.flowMilestone, flowPathsElement.flowMilestone) && Objects.equals(this.flowOutcome, flowPathsElement.flowOutcome);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.parentId, this.type, this.count, this.flows, this.flowOutcomeValue, this.flowMilestone, this.flowOutcome});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlowPathsElement {\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    flows: ").append(this.toIndentedString(this.flows)).append("\n");
        sb.append("    flowOutcomeValue: ").append(this.toIndentedString((Object)this.flowOutcomeValue)).append("\n");
        sb.append("    flowMilestone: ").append(this.toIndentedString(this.flowMilestone)).append("\n");
        sb.append("    flowOutcome: ").append(this.toIndentedString(this.flowOutcome)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ABANDONED("Abandoned"),
        AGENTESCALATION("AgentEscalation"),
        DISCONNECT("Disconnect"),
        ERROR("Error"),
        EXIT("Exit"),
        MILESTONE("Milestone"),
        OUTCOME("Outcome"),
        RECOGNITIONFAILURE("RecognitionFailure"),
        ROOT("Root"),
        TRANSFERRETURNTOAGENT("TransferReturnToAgent"),
        TRANSFERTOACD("TransferToAcd"),
        TRANSFERTOACDVOICEMAIL("TransferToAcdVoicemail"),
        TRANSFERTOFLOW("TransferToFlow"),
        TRANSFERTOGROUP("TransferToGroup"),
        TRANSFERTOGROUPVOICEMAIL("TransferToGroupVoicemail"),
        TRANSFERTONUMBER("TransferToNumber"),
        TRANSFERTOSECUREFLOW("TransferToSecureFlow"),
        TRANSFERTOUNKNOWN("TransferToUnknown"),
        TRANSFERTOUSER("TransferToUser"),
        TRANSFERTOUSERVOICEMAIL("TransferToUserVoicemail");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=FlowOutcomeValueEnumDeserializer.class)
    public static enum FlowOutcomeValueEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        FAILURE("FAILURE"),
        SUCCESS("SUCCESS"),
        UNKNOWN("UNKNOWN");

        private String value;

        private FlowOutcomeValueEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FlowOutcomeValueEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FlowOutcomeValueEnum value : FlowOutcomeValueEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FlowOutcomeValueEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FlowOutcomeValueEnumDeserializer
    extends StdDeserializer<FlowOutcomeValueEnum> {
        public FlowOutcomeValueEnumDeserializer() {
            super(FlowOutcomeValueEnumDeserializer.class);
        }

        public FlowOutcomeValueEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FlowOutcomeValueEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

