/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class FacebookDataIngestionRuleVersionResponse
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private StatusEnum status = null;
    private Integer version = null;
    private String integrationId = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private String selfUri = null;

    public FacebookDataIngestionRuleVersionResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="ID of the Facebook data ingestion rule.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public FacebookDataIngestionRuleVersionResponse name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the data ingestion rule.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FacebookDataIngestionRuleVersionResponse description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="A description of the data ingestion rule.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public FacebookDataIngestionRuleVersionResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the data ingestion rule.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public FacebookDataIngestionRuleVersionResponse version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="The version number of the data ingestion rule.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public FacebookDataIngestionRuleVersionResponse integrationId(String integrationId) {
        this.integrationId = integrationId;
        return this;
    }

    @ApiModelProperty(example="null", value="The Integration Id from which public social posts are ingested. This entity is created using the /conversations/messaging/integrations/facebook resource")
    @JsonProperty(value="integrationId")
    public String getIntegrationId() {
        return this.integrationId;
    }

    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    @ApiModelProperty(example="null", value="Date this ingestion rule was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Date this ingestion rule was modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FacebookDataIngestionRuleVersionResponse facebookDataIngestionRuleVersionResponse = (FacebookDataIngestionRuleVersionResponse)o;
        return Objects.equals(this.id, facebookDataIngestionRuleVersionResponse.id) && Objects.equals(this.name, facebookDataIngestionRuleVersionResponse.name) && Objects.equals(this.description, facebookDataIngestionRuleVersionResponse.description) && Objects.equals((Object)this.status, (Object)facebookDataIngestionRuleVersionResponse.status) && Objects.equals(this.version, facebookDataIngestionRuleVersionResponse.version) && Objects.equals(this.integrationId, facebookDataIngestionRuleVersionResponse.integrationId) && Objects.equals(this.dateCreated, facebookDataIngestionRuleVersionResponse.dateCreated) && Objects.equals(this.dateModified, facebookDataIngestionRuleVersionResponse.dateModified) && Objects.equals(this.selfUri, facebookDataIngestionRuleVersionResponse.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.status, this.version, this.integrationId, this.dateCreated, this.dateModified, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FacebookDataIngestionRuleVersionResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    integrationId: ").append(this.toIndentedString(this.integrationId)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("Active"),
        DELETED("Deleted"),
        ERROR("Error"),
        PAUSED("Paused"),
        PENDING("Pending"),
        SYSTEMPAUSED("SystemPaused");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

