/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.ConversationReference;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.QueueReference;
import com.mypurecloud.sdk.v2.model.SurveyErrorDetails;
import com.mypurecloud.sdk.v2.model.SurveyForm;
import com.mypurecloud.sdk.v2.model.SurveyScoringSet;
import com.mypurecloud.sdk.v2.model.Team;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class Survey
implements Serializable {
    private String id = null;
    private String name = null;
    private ConversationReference conversation = null;
    private SurveyForm surveyForm = null;
    private DomainEntityRef agent = null;
    private StatusEnum status = null;
    private QueueReference queue = null;
    private SurveyScoringSet answers = null;
    private Date completedDate = null;
    private SurveyErrorDetails surveyErrorDetails = null;
    private Team agentTeam = null;
    private SurveyTypeEnum surveyType = null;
    private Boolean missingRequiredAnswer = null;
    private AddressableEntityRef flow = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Survey name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Survey conversation(ConversationReference conversation) {
        this.conversation = conversation;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="conversation")
    public ConversationReference getConversation() {
        return this.conversation;
    }

    public void setConversation(ConversationReference conversation) {
        this.conversation = conversation;
    }

    public Survey surveyForm(SurveyForm surveyForm) {
        this.surveyForm = surveyForm;
        return this;
    }

    @ApiModelProperty(example="null", value="Survey form used for this survey.")
    @JsonProperty(value="surveyForm")
    public SurveyForm getSurveyForm() {
        return this.surveyForm;
    }

    public void setSurveyForm(SurveyForm surveyForm) {
        this.surveyForm = surveyForm;
    }

    public Survey agent(DomainEntityRef agent) {
        this.agent = agent;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="agent")
    public DomainEntityRef getAgent() {
        return this.agent;
    }

    public void setAgent(DomainEntityRef agent) {
        this.agent = agent;
    }

    public Survey status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Survey queue(QueueReference queue) {
        this.queue = queue;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="queue")
    public QueueReference getQueue() {
        return this.queue;
    }

    public void setQueue(QueueReference queue) {
        this.queue = queue;
    }

    public Survey answers(SurveyScoringSet answers) {
        this.answers = answers;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="answers")
    public SurveyScoringSet getAnswers() {
        return this.answers;
    }

    public void setAnswers(SurveyScoringSet answers) {
        this.answers = answers;
    }

    public Survey completedDate(Date completedDate) {
        this.completedDate = completedDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="completedDate")
    public Date getCompletedDate() {
        return this.completedDate;
    }

    public void setCompletedDate(Date completedDate) {
        this.completedDate = completedDate;
    }

    public Survey surveyErrorDetails(SurveyErrorDetails surveyErrorDetails) {
        this.surveyErrorDetails = surveyErrorDetails;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional information about what happened when the survey is in Error status.")
    @JsonProperty(value="surveyErrorDetails")
    public SurveyErrorDetails getSurveyErrorDetails() {
        return this.surveyErrorDetails;
    }

    public void setSurveyErrorDetails(SurveyErrorDetails surveyErrorDetails) {
        this.surveyErrorDetails = surveyErrorDetails;
    }

    public Survey agentTeam(Team agentTeam) {
        this.agentTeam = agentTeam;
        return this;
    }

    @ApiModelProperty(example="null", value="The team that the agent belongs to")
    @JsonProperty(value="agentTeam")
    public Team getAgentTeam() {
        return this.agentTeam;
    }

    public void setAgentTeam(Team agentTeam) {
        this.agentTeam = agentTeam;
    }

    public Survey surveyType(SurveyTypeEnum surveyType) {
        this.surveyType = surveyType;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of the survey")
    @JsonProperty(value="surveyType")
    public SurveyTypeEnum getSurveyType() {
        return this.surveyType;
    }

    public void setSurveyType(SurveyTypeEnum surveyType) {
        this.surveyType = surveyType;
    }

    public Survey missingRequiredAnswer(Boolean missingRequiredAnswer) {
        this.missingRequiredAnswer = missingRequiredAnswer;
        return this;
    }

    @ApiModelProperty(example="null", value="True if any of the required questions for the survey form have not been answered. Null if survey is not finished.")
    @JsonProperty(value="missingRequiredAnswer")
    public Boolean getMissingRequiredAnswer() {
        return this.missingRequiredAnswer;
    }

    public void setMissingRequiredAnswer(Boolean missingRequiredAnswer) {
        this.missingRequiredAnswer = missingRequiredAnswer;
    }

    public Survey flow(AddressableEntityRef flow) {
        this.flow = flow;
        return this;
    }

    @ApiModelProperty(example="null", value="An Architect flow that executed in order to collect the answers for this survey.")
    @JsonProperty(value="flow")
    public AddressableEntityRef getFlow() {
        return this.flow;
    }

    public void setFlow(AddressableEntityRef flow) {
        this.flow = flow;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Survey survey = (Survey)o;
        return Objects.equals(this.id, survey.id) && Objects.equals(this.name, survey.name) && Objects.equals(this.conversation, survey.conversation) && Objects.equals(this.surveyForm, survey.surveyForm) && Objects.equals(this.agent, survey.agent) && Objects.equals((Object)this.status, (Object)survey.status) && Objects.equals(this.queue, survey.queue) && Objects.equals(this.answers, survey.answers) && Objects.equals(this.completedDate, survey.completedDate) && Objects.equals(this.surveyErrorDetails, survey.surveyErrorDetails) && Objects.equals(this.agentTeam, survey.agentTeam) && Objects.equals((Object)this.surveyType, (Object)survey.surveyType) && Objects.equals(this.missingRequiredAnswer, survey.missingRequiredAnswer) && Objects.equals(this.flow, survey.flow) && Objects.equals(this.selfUri, survey.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.conversation, this.surveyForm, this.agent, this.status, this.queue, this.answers, this.completedDate, this.surveyErrorDetails, this.agentTeam, this.surveyType, this.missingRequiredAnswer, this.flow, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Survey {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    conversation: ").append(this.toIndentedString(this.conversation)).append("\n");
        sb.append("    surveyForm: ").append(this.toIndentedString(this.surveyForm)).append("\n");
        sb.append("    agent: ").append(this.toIndentedString(this.agent)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    queue: ").append(this.toIndentedString(this.queue)).append("\n");
        sb.append("    answers: ").append(this.toIndentedString(this.answers)).append("\n");
        sb.append("    completedDate: ").append(this.toIndentedString(this.completedDate)).append("\n");
        sb.append("    surveyErrorDetails: ").append(this.toIndentedString(this.surveyErrorDetails)).append("\n");
        sb.append("    agentTeam: ").append(this.toIndentedString(this.agentTeam)).append("\n");
        sb.append("    surveyType: ").append(this.toIndentedString((Object)this.surveyType)).append("\n");
        sb.append("    missingRequiredAnswer: ").append(this.toIndentedString(this.missingRequiredAnswer)).append("\n");
        sb.append("    flow: ").append(this.toIndentedString(this.flow)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PENDING("Pending"),
        SENT("Sent"),
        INPROGRESS("InProgress"),
        FINISHED("Finished"),
        OPTOUT("OptOut"),
        ERROR("Error"),
        EXPIRED("Expired");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=SurveyTypeEnumDeserializer.class)
    public static enum SurveyTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        WEB("Web"),
        VOICE("Voice");

        private String value;

        private SurveyTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SurveyTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SurveyTypeEnum value : SurveyTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SurveyTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SurveyTypeEnumDeserializer
    extends StdDeserializer<SurveyTypeEnum> {
        public SurveyTypeEnumDeserializer() {
            super(SurveyTypeEnumDeserializer.class);
        }

        public SurveyTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SurveyTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

