/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.FlowHealthErrorInfo;
import com.mypurecloud.sdk.v2.model.FlowHealthIntentUtterance;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class HealthInfo
implements Serializable {
    private StatusEnum status = null;
    private FlowHealthErrorInfo errorInfo = null;
    private Float overallScore = null;
    private Long issueCount = null;
    private List<StaticValidationResultsEnum> staticValidationResults = new ArrayList<StaticValidationResultsEnum>();
    private List<FlowHealthIntentUtterance> utterances = new ArrayList<FlowHealthIntentUtterance>();

    public HealthInfo status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="Status of health computation for this intent.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public HealthInfo errorInfo(FlowHealthErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="Error details for the intent, if any.")
    @JsonProperty(value="errorInfo")
    public FlowHealthErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    public void setErrorInfo(FlowHealthErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
    }

    public HealthInfo overallScore(Float overallScore) {
        this.overallScore = overallScore;
        return this;
    }

    @ApiModelProperty(example="null", value="Overall health score for the intent ranged between 0 and 100 as 100 is the perfect health score.")
    @JsonProperty(value="overallScore")
    public Float getOverallScore() {
        return this.overallScore;
    }

    public void setOverallScore(Float overallScore) {
        this.overallScore = overallScore;
    }

    public HealthInfo issueCount(Long issueCount) {
        this.issueCount = issueCount;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of issues found in the intent.")
    @JsonProperty(value="issueCount")
    public Long getIssueCount() {
        return this.issueCount;
    }

    public void setIssueCount(Long issueCount) {
        this.issueCount = issueCount;
    }

    public HealthInfo staticValidationResults(List<StaticValidationResultsEnum> staticValidationResults) {
        this.staticValidationResults = staticValidationResults;
        return this;
    }

    @ApiModelProperty(example="null", value="Validation results for the intent.")
    @JsonProperty(value="staticValidationResults")
    public List<StaticValidationResultsEnum> getStaticValidationResults() {
        return this.staticValidationResults;
    }

    public void setStaticValidationResults(List<StaticValidationResultsEnum> staticValidationResults) {
        this.staticValidationResults = staticValidationResults;
    }

    public HealthInfo utterances(List<FlowHealthIntentUtterance> utterances) {
        this.utterances = utterances;
        return this;
    }

    @ApiModelProperty(example="null", value="Utterances for this intent.")
    @JsonProperty(value="utterances")
    public List<FlowHealthIntentUtterance> getUtterances() {
        return this.utterances;
    }

    public void setUtterances(List<FlowHealthIntentUtterance> utterances) {
        this.utterances = utterances;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HealthInfo healthInfo = (HealthInfo)o;
        return Objects.equals((Object)this.status, (Object)healthInfo.status) && Objects.equals(this.errorInfo, healthInfo.errorInfo) && Objects.equals(this.overallScore, healthInfo.overallScore) && Objects.equals(this.issueCount, healthInfo.issueCount) && Objects.equals(this.staticValidationResults, healthInfo.staticValidationResults) && Objects.equals(this.utterances, healthInfo.utterances);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.errorInfo, this.overallScore, this.issueCount, this.staticValidationResults, this.utterances});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HealthInfo {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    errorInfo: ").append(this.toIndentedString(this.errorInfo)).append("\n");
        sb.append("    overallScore: ").append(this.toIndentedString(this.overallScore)).append("\n");
        sb.append("    issueCount: ").append(this.toIndentedString(this.issueCount)).append("\n");
        sb.append("    staticValidationResults: ").append(this.toIndentedString(this.staticValidationResults)).append("\n");
        sb.append("    utterances: ").append(this.toIndentedString(this.utterances)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INPROGRESS("InProgress"),
        COMPLETED("Completed"),
        ERROR("Error");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StaticValidationResultsEnumDeserializer.class)
    public static enum StaticValidationResultsEnum {
        TOOFEWUTTERANCES("TooFewUtterances"),
        TOOMANYUTTERANCES("TooManyUtterances"),
        UTTERANCETOOSHORT("UtteranceTooShort"),
        UTTERANCETOOLONG("UtteranceTooLong");

        private String value;

        private StaticValidationResultsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StaticValidationResultsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StaticValidationResultsEnum value : StaticValidationResultsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StaticValidationResultsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StaticValidationResultsEnumDeserializer
    extends StdDeserializer<StaticValidationResultsEnum> {
        public StaticValidationResultsEnumDeserializer() {
            super(StaticValidationResultsEnumDeserializer.class);
        }

        public StaticValidationResultsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StaticValidationResultsEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

