/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.DynamicGroupQuery;
import java.util.HashMap;
import java.util.Map;

public class PutGroupDynamicsettingsRequest {
    private String groupId;
    private DynamicGroupQuery body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public PutGroupDynamicsettingsRequest withGroupId(String groupId) {
        this.setGroupId(groupId);
        return this;
    }

    public DynamicGroupQuery getBody() {
        return this.body;
    }

    public void setBody(DynamicGroupQuery body) {
        this.body = body;
    }

    public PutGroupDynamicsettingsRequest withBody(DynamicGroupQuery body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutGroupDynamicsettingsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<DynamicGroupQuery> withHttpInfo() {
        if (this.groupId == null) {
            throw new IllegalStateException("Missing the required parameter 'groupId' when building request for PutGroupDynamicsettingsRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutGroupDynamicsettingsRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/groups/{groupId}/dynamicsettings").withPathParameter("groupId", this.groupId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String groupId, DynamicGroupQuery body) {
        return new Builder().withRequiredParams(groupId, body);
    }

    public static class Builder {
        private final PutGroupDynamicsettingsRequest request = new PutGroupDynamicsettingsRequest();

        private Builder() {
        }

        public Builder withGroupId(String groupId) {
            this.request.setGroupId(groupId);
            return this;
        }

        public Builder withBody(DynamicGroupQuery body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String groupId, DynamicGroupQuery body) {
            this.request.setGroupId(groupId);
            this.request.setBody(body);
            return this;
        }

        public PutGroupDynamicsettingsRequest build() {
            if (this.request.groupId == null) {
                throw new IllegalStateException("Missing the required parameter 'groupId' when building request for PutGroupDynamicsettingsRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutGroupDynamicsettingsRequest.");
            }
            return this.request;
        }
    }
}

