/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DialerAction
implements Serializable {
    private TypeEnum type = null;
    private ActionTypeNameEnum actionTypeName = null;
    private UpdateOptionEnum updateOption = null;
    private Map<String, String> properties = new HashMap<String, String>();

    public DialerAction type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of this DialerAction.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public DialerAction actionTypeName(ActionTypeNameEnum actionTypeName) {
        this.actionTypeName = actionTypeName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Additional type specification for this DialerAction.")
    @JsonProperty(value="actionTypeName")
    public ActionTypeNameEnum getActionTypeName() {
        return this.actionTypeName;
    }

    public void setActionTypeName(ActionTypeNameEnum actionTypeName) {
        this.actionTypeName = actionTypeName;
    }

    public DialerAction updateOption(UpdateOptionEnum updateOption) {
        this.updateOption = updateOption;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies how a contact attribute should be updated. Required for MODIFY_CONTACT_ATTRIBUTE.")
    @JsonProperty(value="updateOption")
    public UpdateOptionEnum getUpdateOption() {
        return this.updateOption;
    }

    public void setUpdateOption(UpdateOptionEnum updateOption) {
        this.updateOption = updateOption;
    }

    public DialerAction properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    @ApiModelProperty(example="null", value="A map of key-value pairs pertinent to the DialerAction. Different types of DialerActions require different properties. MODIFY_CONTACT_ATTRIBUTE with an updateOption of SET takes a contact column as the key and accepts any value. SCHEDULE_CALLBACK takes a key 'callbackOffset' that specifies how far in the future the callback should be scheduled, in minutes. SET_CALLER_ID takes two keys: 'callerAddress', which should be the caller id phone number, and 'callerName'. For either key, you can also specify a column on the contact to get the value from. To do this, specify 'contact.Column', where 'Column' is the name of the contact column from which to get the value. SET_SKILLS takes a key 'skills' with an array of skill ids.")
    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DialerAction dialerAction = (DialerAction)o;
        return Objects.equals((Object)this.type, (Object)dialerAction.type) && Objects.equals((Object)this.actionTypeName, (Object)dialerAction.actionTypeName) && Objects.equals((Object)this.updateOption, (Object)dialerAction.updateOption) && Objects.equals(this.properties, dialerAction.properties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.actionTypeName, this.updateOption, this.properties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DialerAction {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    actionTypeName: ").append(this.toIndentedString((Object)this.actionTypeName)).append("\n");
        sb.append("    updateOption: ").append(this.toIndentedString((Object)this.updateOption)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum UpdateOptionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SET("SET"),
        INCREMENT("INCREMENT"),
        DECREMENT("DECREMENT"),
        CURRENT_TIME("CURRENT_TIME");

        private String value;

        private UpdateOptionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static UpdateOptionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (UpdateOptionEnum value : UpdateOptionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return UpdateOptionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum ActionTypeNameEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DO_NOT_DIAL("DO_NOT_DIAL"),
        MODIFY_CONTACT_ATTRIBUTE("MODIFY_CONTACT_ATTRIBUTE"),
        SWITCH_TO_PREVIEW("SWITCH_TO_PREVIEW"),
        APPEND_NUMBER_TO_DNC_LIST("APPEND_NUMBER_TO_DNC_LIST"),
        SCHEDULE_CALLBACK("SCHEDULE_CALLBACK"),
        CONTACT_UNCALLABLE("CONTACT_UNCALLABLE"),
        NUMBER_UNCALLABLE("NUMBER_UNCALLABLE"),
        SET_CALLER_ID("SET_CALLER_ID"),
        SET_SKILLS("SET_SKILLS");

        private String value;

        private ActionTypeNameEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActionTypeNameEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActionTypeNameEnum value : ActionTypeNameEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActionTypeNameEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTION("Action"),
        MODIFYCONTACTATTRIBUTE("modifyContactAttribute");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

