/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.LearningModulePreviewUpdateRequest;
import java.util.HashMap;
import java.util.Map;

public class PutLearningModulePreviewRequest {
    private String moduleId;
    private LearningModulePreviewUpdateRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public PutLearningModulePreviewRequest withModuleId(String moduleId) {
        this.setModuleId(moduleId);
        return this;
    }

    public LearningModulePreviewUpdateRequest getBody() {
        return this.body;
    }

    public void setBody(LearningModulePreviewUpdateRequest body) {
        this.body = body;
    }

    public PutLearningModulePreviewRequest withBody(LearningModulePreviewUpdateRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutLearningModulePreviewRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<LearningModulePreviewUpdateRequest> withHttpInfo() {
        if (this.moduleId == null) {
            throw new IllegalStateException("Missing the required parameter 'moduleId' when building request for PutLearningModulePreviewRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutLearningModulePreviewRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/learning/modules/{moduleId}/preview").withPathParameter("moduleId", this.moduleId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String moduleId, LearningModulePreviewUpdateRequest body) {
        return new Builder().withRequiredParams(moduleId, body);
    }

    public static class Builder {
        private final PutLearningModulePreviewRequest request = new PutLearningModulePreviewRequest();

        private Builder() {
        }

        public Builder withModuleId(String moduleId) {
            this.request.setModuleId(moduleId);
            return this;
        }

        public Builder withBody(LearningModulePreviewUpdateRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String moduleId, LearningModulePreviewUpdateRequest body) {
            this.request.setModuleId(moduleId);
            this.request.setBody(body);
            return this;
        }

        public PutLearningModulePreviewRequest build() {
            if (this.request.moduleId == null) {
                throw new IllegalStateException("Missing the required parameter 'moduleId' when building request for PutLearningModulePreviewRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutLearningModulePreviewRequest.");
            }
            return this.request;
        }
    }
}

