/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetFlowVersionHealthRequest {
    private String flowId;
    private String versionId;
    private String language;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public GetFlowVersionHealthRequest withFlowId(String flowId) {
        this.setFlowId(flowId);
        return this;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public GetFlowVersionHealthRequest withVersionId(String versionId) {
        this.setVersionId(versionId);
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public GetFlowVersionHealthRequest withLanguage(String language) {
        this.setLanguage(language);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetFlowVersionHealthRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.flowId == null) {
            throw new IllegalStateException("Missing the required parameter 'flowId' when building request for GetFlowVersionHealthRequest.");
        }
        if (this.versionId == null) {
            throw new IllegalStateException("Missing the required parameter 'versionId' when building request for GetFlowVersionHealthRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/flows/{flowId}/versions/{versionId}/health").withPathParameter("flowId", this.flowId).withPathParameter("versionId", this.versionId).withQueryParameters("language", "", this.language).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String flowId, String versionId) {
        return new Builder().withRequiredParams(flowId, versionId);
    }

    public static class Builder {
        private final GetFlowVersionHealthRequest request = new GetFlowVersionHealthRequest();

        private Builder() {
        }

        public Builder withFlowId(String flowId) {
            this.request.setFlowId(flowId);
            return this;
        }

        public Builder withVersionId(String versionId) {
            this.request.setVersionId(versionId);
            return this;
        }

        public Builder withLanguage(String language) {
            this.request.setLanguage(language);
            return this;
        }

        public Builder withLanguage(languageValues language) {
            this.request.setLanguage(language.toString());
            return this;
        }

        public Builder withRequiredParams(String flowId, String versionId) {
            this.request.setFlowId(flowId);
            this.request.setVersionId(versionId);
            return this;
        }

        public GetFlowVersionHealthRequest build() {
            if (this.request.flowId == null) {
                throw new IllegalStateException("Missing the required parameter 'flowId' when building request for GetFlowVersionHealthRequest.");
            }
            if (this.request.versionId == null) {
                throw new IllegalStateException("Missing the required parameter 'versionId' when building request for GetFlowVersionHealthRequest.");
            }
            return this.request;
        }
    }

    public static enum languageValues {
        EN_US("en-us"),
        EN_GB("en-gb"),
        EN_AU("en-au"),
        EN_ZA("en-za"),
        EN_NZ("en-nz"),
        EN_IE("en-ie"),
        FR_CA("fr-ca"),
        FR_FR("fr-fr"),
        ES_US("es-us"),
        ES_ES("es-es"),
        ES_MX("es-mx"),
        DE_DE("de-de"),
        IT_IT("it-it"),
        PT_BR("pt-br"),
        PT_PT("pt-pt"),
        NL_NL("nl-nl");

        private String value;

        private languageValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static languageValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (languageValues value : languageValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return languageValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

