/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class Term
implements Serializable {
    private String word = null;
    private ParticipantTypeEnum participantType = null;

    public Term word(String word) {
        this.word = word;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Find term in interaction")
    @JsonProperty(value="word")
    public String getWord() {
        return this.word;
    }

    public void setWord(String word) {
        this.word = word;
    }

    public Term participantType(ParticipantTypeEnum participantType) {
        this.participantType = participantType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Dictates if term operand must come from the internal, external or both participants")
    @JsonProperty(value="participantType")
    public ParticipantTypeEnum getParticipantType() {
        return this.participantType;
    }

    public void setParticipantType(ParticipantTypeEnum participantType) {
        this.participantType = participantType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Term term = (Term)o;
        return Objects.equals(this.word, term.word) && Objects.equals((Object)this.participantType, (Object)term.participantType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.word, this.participantType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Term {\n");
        sb.append("    word: ").append(this.toIndentedString(this.word)).append("\n");
        sb.append("    participantType: ").append(this.toIndentedString((Object)this.participantType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ParticipantTypeEnumDeserializer.class)
    public static enum ParticipantTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INTERNAL("Internal"),
        EXTERNAL("External"),
        BOTH("Both");

        private String value;

        private ParticipantTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ParticipantTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ParticipantTypeEnum value : ParticipantTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ParticipantTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ParticipantTypeEnumDeserializer
    extends StdDeserializer<ParticipantTypeEnum> {
        public ParticipantTypeEnumDeserializer() {
            super(ParticipantTypeEnumDeserializer.class);
        }

        public ParticipantTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ParticipantTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

