/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class TransferToAgentRequest
implements Serializable {
    private TransferTypeEnum transferType = null;
    private String userId = null;
    private String userName = null;
    private String userDisplayName = null;
    private Boolean voicemail = null;

    public TransferToAgentRequest transferType(TransferTypeEnum transferType) {
        this.transferType = transferType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of transfer to perform. Attended, where the initiating agent maintains ownership of the conversation until the intended recipient accepts the transfer, or Unattended, where the initiating agent immediately disconnects. Default is Unattended.")
    @JsonProperty(value="transferType")
    public TransferTypeEnum getTransferType() {
        return this.transferType;
    }

    public void setTransferType(TransferTypeEnum transferType) {
        this.transferType = transferType;
    }

    public TransferToAgentRequest userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the internal user.")
    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public TransferToAgentRequest userName(String userName) {
        this.userName = userName;
        return this;
    }

    @ApiModelProperty(example="null", value="The userName (like user\u2019s email) of the internal user.")
    @JsonProperty(value="userName")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public TransferToAgentRequest userDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the internal user.")
    @JsonProperty(value="userDisplayName")
    public String getUserDisplayName() {
        return this.userDisplayName;
    }

    public void setUserDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
    }

    public TransferToAgentRequest voicemail(Boolean voicemail) {
        this.voicemail = voicemail;
        return this;
    }

    @ApiModelProperty(example="null", value="If true, transfer to the voicemail inbox of the participant that is being replaced.")
    @JsonProperty(value="voicemail")
    public Boolean getVoicemail() {
        return this.voicemail;
    }

    public void setVoicemail(Boolean voicemail) {
        this.voicemail = voicemail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferToAgentRequest transferToAgentRequest = (TransferToAgentRequest)o;
        return Objects.equals((Object)this.transferType, (Object)transferToAgentRequest.transferType) && Objects.equals(this.userId, transferToAgentRequest.userId) && Objects.equals(this.userName, transferToAgentRequest.userName) && Objects.equals(this.userDisplayName, transferToAgentRequest.userDisplayName) && Objects.equals(this.voicemail, transferToAgentRequest.voicemail);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.transferType, this.userId, this.userName, this.userDisplayName, this.voicemail});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferToAgentRequest {\n");
        sb.append("    transferType: ").append(this.toIndentedString((Object)this.transferType)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("    userDisplayName: ").append(this.toIndentedString(this.userDisplayName)).append("\n");
        sb.append("    voicemail: ").append(this.toIndentedString(this.voicemail)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TransferTypeEnumDeserializer.class)
    public static enum TransferTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ATTENDED("Attended"),
        UNATTENDED("Unattended");

        private String value;

        private TransferTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TransferTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TransferTypeEnum value : TransferTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TransferTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TransferTypeEnumDeserializer
    extends StdDeserializer<TransferTypeEnum> {
        public TransferTypeEnumDeserializer() {
            super(TransferTypeEnumDeserializer.class);
        }

        public TransferTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TransferTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

