/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.CustomEventAttribute;
import com.mypurecloud.sdk.v2.model.Device;
import com.mypurecloud.sdk.v2.model.JourneyApp;
import com.mypurecloud.sdk.v2.model.JourneyCampaign;
import com.mypurecloud.sdk.v2.model.JourneyGeolocation;
import com.mypurecloud.sdk.v2.model.NetworkConnectivity;
import com.mypurecloud.sdk.v2.model.SdkLibrary;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class AppEvent
implements Serializable {
    private String eventName = null;
    private String screenName = null;
    private JourneyApp app = null;
    private Device device = null;
    private String ipAddress = null;
    private String ipOrganization = null;
    private JourneyGeolocation geolocation = null;
    private SdkLibrary sdkLibrary = null;
    private NetworkConnectivity networkConnectivity = null;
    private JourneyCampaign mktCampaign = null;
    private String searchQuery = null;
    private Map<String, CustomEventAttribute> attributes = null;
    private Map<String, CustomEventAttribute> traits = null;

    public AppEvent eventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Represents the action the customer performed. A good event name is typically an object followed by the action performed in past tense (e.g. screen_viewed, order_completed, user_registered).")
    @JsonProperty(value="eventName")
    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public AppEvent screenName(String screenName) {
        this.screenName = screenName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the screen in the app that the event took place.")
    @JsonProperty(value="screenName")
    public String getScreenName() {
        return this.screenName;
    }

    public void setScreenName(String screenName) {
        this.screenName = screenName;
    }

    public AppEvent app(JourneyApp app) {
        this.app = app;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Application that the customer is interacting with.")
    @JsonProperty(value="app")
    public JourneyApp getApp() {
        return this.app;
    }

    public void setApp(JourneyApp app) {
        this.app = app;
    }

    public AppEvent device(Device device) {
        this.device = device;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Customer's device.")
    @JsonProperty(value="device")
    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public AppEvent ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="Customer's IP address. May be null if the business configures the tracker to not collect IP addresses.")
    @JsonProperty(value="ipAddress")
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public AppEvent ipOrganization(String ipOrganization) {
        this.ipOrganization = ipOrganization;
        return this;
    }

    @ApiModelProperty(example="null", value="Customer's IP-based organization or ISP name.")
    @JsonProperty(value="ipOrganization")
    public String getIpOrganization() {
        return this.ipOrganization;
    }

    public void setIpOrganization(String ipOrganization) {
        this.ipOrganization = ipOrganization;
    }

    public AppEvent geolocation(JourneyGeolocation geolocation) {
        this.geolocation = geolocation;
        return this;
    }

    @ApiModelProperty(example="null", value="Customer's geolocation.")
    @JsonProperty(value="geolocation")
    public JourneyGeolocation getGeolocation() {
        return this.geolocation;
    }

    public void setGeolocation(JourneyGeolocation geolocation) {
        this.geolocation = geolocation;
    }

    public AppEvent sdkLibrary(SdkLibrary sdkLibrary) {
        this.sdkLibrary = sdkLibrary;
        return this;
    }

    @ApiModelProperty(example="null", value="SDK library used to generate the event.")
    @JsonProperty(value="sdkLibrary")
    public SdkLibrary getSdkLibrary() {
        return this.sdkLibrary;
    }

    public void setSdkLibrary(SdkLibrary sdkLibrary) {
        this.sdkLibrary = sdkLibrary;
    }

    public AppEvent networkConnectivity(NetworkConnectivity networkConnectivity) {
        this.networkConnectivity = networkConnectivity;
        return this;
    }

    @ApiModelProperty(example="null", value="Information relating to the device's network connectivity.")
    @JsonProperty(value="networkConnectivity")
    public NetworkConnectivity getNetworkConnectivity() {
        return this.networkConnectivity;
    }

    public void setNetworkConnectivity(NetworkConnectivity networkConnectivity) {
        this.networkConnectivity = networkConnectivity;
    }

    public AppEvent mktCampaign(JourneyCampaign mktCampaign) {
        this.mktCampaign = mktCampaign;
        return this;
    }

    @ApiModelProperty(example="null", value="Marketing / traffic source information.")
    @JsonProperty(value="mktCampaign")
    public JourneyCampaign getMktCampaign() {
        return this.mktCampaign;
    }

    public void setMktCampaign(JourneyCampaign mktCampaign) {
        this.mktCampaign = mktCampaign;
    }

    public AppEvent searchQuery(String searchQuery) {
        this.searchQuery = searchQuery;
        return this;
    }

    @ApiModelProperty(example="null", value="Represents the keywords in a customer search query.")
    @JsonProperty(value="searchQuery")
    public String getSearchQuery() {
        return this.searchQuery;
    }

    public void setSearchQuery(String searchQuery) {
        this.searchQuery = searchQuery;
    }

    public AppEvent attributes(Map<String, CustomEventAttribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="User-defined attributes associated with a particular event.")
    @JsonProperty(value="attributes")
    public Map<String, CustomEventAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, CustomEventAttribute> attributes) {
        this.attributes = attributes;
    }

    public AppEvent traits(Map<String, CustomEventAttribute> traits) {
        this.traits = traits;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Traits are attributes intrinsic to the customer that may be sent in selected events. Examples are email, name, phone.")
    @JsonProperty(value="traits")
    public Map<String, CustomEventAttribute> getTraits() {
        return this.traits;
    }

    public void setTraits(Map<String, CustomEventAttribute> traits) {
        this.traits = traits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppEvent appEvent = (AppEvent)o;
        return Objects.equals(this.eventName, appEvent.eventName) && Objects.equals(this.screenName, appEvent.screenName) && Objects.equals(this.app, appEvent.app) && Objects.equals(this.device, appEvent.device) && Objects.equals(this.ipAddress, appEvent.ipAddress) && Objects.equals(this.ipOrganization, appEvent.ipOrganization) && Objects.equals(this.geolocation, appEvent.geolocation) && Objects.equals(this.sdkLibrary, appEvent.sdkLibrary) && Objects.equals(this.networkConnectivity, appEvent.networkConnectivity) && Objects.equals(this.mktCampaign, appEvent.mktCampaign) && Objects.equals(this.searchQuery, appEvent.searchQuery) && Objects.equals(this.attributes, appEvent.attributes) && Objects.equals(this.traits, appEvent.traits);
    }

    public int hashCode() {
        return Objects.hash(this.eventName, this.screenName, this.app, this.device, this.ipAddress, this.ipOrganization, this.geolocation, this.sdkLibrary, this.networkConnectivity, this.mktCampaign, this.searchQuery, this.attributes, this.traits);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppEvent {\n");
        sb.append("    eventName: ").append(this.toIndentedString(this.eventName)).append("\n");
        sb.append("    screenName: ").append(this.toIndentedString(this.screenName)).append("\n");
        sb.append("    app: ").append(this.toIndentedString(this.app)).append("\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    ipOrganization: ").append(this.toIndentedString(this.ipOrganization)).append("\n");
        sb.append("    geolocation: ").append(this.toIndentedString(this.geolocation)).append("\n");
        sb.append("    sdkLibrary: ").append(this.toIndentedString(this.sdkLibrary)).append("\n");
        sb.append("    networkConnectivity: ").append(this.toIndentedString(this.networkConnectivity)).append("\n");
        sb.append("    mktCampaign: ").append(this.toIndentedString(this.mktCampaign)).append("\n");
        sb.append("    searchQuery: ").append(this.toIndentedString(this.searchQuery)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    traits: ").append(this.toIndentedString(this.traits)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

