/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class ConditionalGroupRoutingCondition
implements Serializable {
    private DomainEntityRef queue = null;
    private MetricEnum metric = null;
    private OperatorEnum operator = null;
    private Double value = null;

    public ConditionalGroupRoutingCondition queue(DomainEntityRef queue) {
        this.queue = queue;
        return this;
    }

    @ApiModelProperty(example="null", value="The queue being evaluated for this rule.  If null, the current queue will be used.")
    @JsonProperty(value="queue")
    public DomainEntityRef getQueue() {
        return this.queue;
    }

    public void setQueue(DomainEntityRef queue) {
        this.queue = queue;
    }

    public ConditionalGroupRoutingCondition metric(MetricEnum metric) {
        this.metric = metric;
        return this;
    }

    @ApiModelProperty(example="null", value="The queue metric being evaluated")
    @JsonProperty(value="metric")
    public MetricEnum getMetric() {
        return this.metric;
    }

    public void setMetric(MetricEnum metric) {
        this.metric = metric;
    }

    public ConditionalGroupRoutingCondition operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(example="null", value="The operator that compares the actual value against the condition value")
    @JsonProperty(value="operator")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public ConditionalGroupRoutingCondition value(Double value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", value="The limit value, beyond which a rule evaluates as true")
    @JsonProperty(value="value")
    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionalGroupRoutingCondition conditionalGroupRoutingCondition = (ConditionalGroupRoutingCondition)o;
        return Objects.equals(this.queue, conditionalGroupRoutingCondition.queue) && Objects.equals((Object)this.metric, (Object)conditionalGroupRoutingCondition.metric) && Objects.equals((Object)this.operator, (Object)conditionalGroupRoutingCondition.operator) && Objects.equals(this.value, conditionalGroupRoutingCondition.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.queue, this.metric, this.operator, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConditionalGroupRoutingCondition {\n");
        sb.append("    queue: ").append(this.toIndentedString(this.queue)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString((Object)this.metric)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MetricEnumDeserializer.class)
    public static enum MetricEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ESTIMATEDWAITTIME("EstimatedWaitTime"),
        SERVICELEVEL("ServiceLevel");

        private String value;

        private MetricEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MetricEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MetricEnum value : MetricEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MetricEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=OperatorEnumDeserializer.class)
    public static enum OperatorEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        GREATERTHAN("GreaterThan"),
        GREATERTHANOREQUALTO("GreaterThanOrEqualTo"),
        LESSTHAN("LessThan"),
        LESSTHANOREQUALTO("LessThanOrEqualTo");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OperatorEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OperatorEnum value : OperatorEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OperatorEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OperatorEnumDeserializer
    extends StdDeserializer<OperatorEnum> {
        public OperatorEnumDeserializer() {
            super(OperatorEnumDeserializer.class);
        }

        public OperatorEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OperatorEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class MetricEnumDeserializer
    extends StdDeserializer<MetricEnum> {
        public MetricEnumDeserializer() {
            super(MetricEnumDeserializer.class);
        }

        public MetricEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MetricEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

