/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.UpdateVerifierRequest;
import java.util.HashMap;
import java.util.Map;

public class PutUserVerifierRequest {
    private String userId;
    private String verifierId;
    private UpdateVerifierRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public PutUserVerifierRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public String getVerifierId() {
        return this.verifierId;
    }

    public void setVerifierId(String verifierId) {
        this.verifierId = verifierId;
    }

    public PutUserVerifierRequest withVerifierId(String verifierId) {
        this.setVerifierId(verifierId);
        return this;
    }

    public UpdateVerifierRequest getBody() {
        return this.body;
    }

    public void setBody(UpdateVerifierRequest body) {
        this.body = body;
    }

    public PutUserVerifierRequest withBody(UpdateVerifierRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutUserVerifierRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<UpdateVerifierRequest> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for PutUserVerifierRequest.");
        }
        if (this.verifierId == null) {
            throw new IllegalStateException("Missing the required parameter 'verifierId' when building request for PutUserVerifierRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutUserVerifierRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/users/{userId}/verifiers/{verifierId}").withPathParameter("userId", this.userId).withPathParameter("verifierId", this.verifierId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId, String verifierId, UpdateVerifierRequest body) {
        return new Builder().withRequiredParams(userId, verifierId, body);
    }

    public static class Builder {
        private final PutUserVerifierRequest request = new PutUserVerifierRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withVerifierId(String verifierId) {
            this.request.setVerifierId(verifierId);
            return this;
        }

        public Builder withBody(UpdateVerifierRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String userId, String verifierId, UpdateVerifierRequest body) {
            this.request.setUserId(userId);
            this.request.setVerifierId(verifierId);
            this.request.setBody(body);
            return this;
        }

        public PutUserVerifierRequest build() {
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for PutUserVerifierRequest.");
            }
            if (this.request.verifierId == null) {
                throw new IllegalStateException("Missing the required parameter 'verifierId' when building request for PutUserVerifierRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutUserVerifierRequest.");
            }
            return this.request;
        }
    }
}

