/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.HrisTimeOffType;
import com.mypurecloud.sdk.v2.model.TimeOffLimitReference;
import com.mypurecloud.sdk.v2.model.WfmVersionedEntityMetadata;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TimeOffPlan
implements Serializable {
    private String id = null;
    private String name = null;
    private List<String> activityCodeIds = new ArrayList<String>();
    private List<TimeOffLimitReference> timeOffLimits = new ArrayList<TimeOffLimitReference>();
    private AutoApprovalRuleEnum autoApprovalRule = null;
    private Integer daysBeforeStartToExpireFromWaitlist = null;
    private HrisTimeOffType hrisTimeOffType = null;
    private Boolean active = null;
    private WfmVersionedEntityMetadata metadata = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public TimeOffPlan name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of this time off plan.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TimeOffPlan activityCodeIds(List<String> activityCodeIds) {
        this.activityCodeIds = activityCodeIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The set of activity code IDs associated with this time off plan.")
    @JsonProperty(value="activityCodeIds")
    public List<String> getActivityCodeIds() {
        return this.activityCodeIds;
    }

    public void setActivityCodeIds(List<String> activityCodeIds) {
        this.activityCodeIds = activityCodeIds;
    }

    public TimeOffPlan timeOffLimits(List<TimeOffLimitReference> timeOffLimits) {
        this.timeOffLimits = timeOffLimits;
        return this;
    }

    @ApiModelProperty(example="null", value="The set of time off limit IDs associated with this time off plan.")
    @JsonProperty(value="timeOffLimits")
    public List<TimeOffLimitReference> getTimeOffLimits() {
        return this.timeOffLimits;
    }

    public void setTimeOffLimits(List<TimeOffLimitReference> timeOffLimits) {
        this.timeOffLimits = timeOffLimits;
    }

    public TimeOffPlan autoApprovalRule(AutoApprovalRuleEnum autoApprovalRule) {
        this.autoApprovalRule = autoApprovalRule;
        return this;
    }

    @ApiModelProperty(example="null", value="Auto approval rule for this time off plan")
    @JsonProperty(value="autoApprovalRule")
    public AutoApprovalRuleEnum getAutoApprovalRule() {
        return this.autoApprovalRule;
    }

    public void setAutoApprovalRule(AutoApprovalRuleEnum autoApprovalRule) {
        this.autoApprovalRule = autoApprovalRule;
    }

    public TimeOffPlan daysBeforeStartToExpireFromWaitlist(Integer daysBeforeStartToExpireFromWaitlist) {
        this.daysBeforeStartToExpireFromWaitlist = daysBeforeStartToExpireFromWaitlist;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of days before the time off request start date for when the request will be expired from the waitlist.")
    @JsonProperty(value="daysBeforeStartToExpireFromWaitlist")
    public Integer getDaysBeforeStartToExpireFromWaitlist() {
        return this.daysBeforeStartToExpireFromWaitlist;
    }

    public void setDaysBeforeStartToExpireFromWaitlist(Integer daysBeforeStartToExpireFromWaitlist) {
        this.daysBeforeStartToExpireFromWaitlist = daysBeforeStartToExpireFromWaitlist;
    }

    public TimeOffPlan hrisTimeOffType(HrisTimeOffType hrisTimeOffType) {
        this.hrisTimeOffType = hrisTimeOffType;
        return this;
    }

    @ApiModelProperty(example="null", value="Time off type, if this time off plan is associated with the integration.")
    @JsonProperty(value="hrisTimeOffType")
    public HrisTimeOffType getHrisTimeOffType() {
        return this.hrisTimeOffType;
    }

    public void setHrisTimeOffType(HrisTimeOffType hrisTimeOffType) {
        this.hrisTimeOffType = hrisTimeOffType;
    }

    public TimeOffPlan active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this time off plan is currently being used by agents.")
    @JsonProperty(value="active")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public TimeOffPlan metadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", value="Version metadata for the time off plan.")
    @JsonProperty(value="metadata")
    public WfmVersionedEntityMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeOffPlan timeOffPlan = (TimeOffPlan)o;
        return Objects.equals(this.id, timeOffPlan.id) && Objects.equals(this.name, timeOffPlan.name) && Objects.equals(this.activityCodeIds, timeOffPlan.activityCodeIds) && Objects.equals(this.timeOffLimits, timeOffPlan.timeOffLimits) && Objects.equals((Object)this.autoApprovalRule, (Object)timeOffPlan.autoApprovalRule) && Objects.equals(this.daysBeforeStartToExpireFromWaitlist, timeOffPlan.daysBeforeStartToExpireFromWaitlist) && Objects.equals(this.hrisTimeOffType, timeOffPlan.hrisTimeOffType) && Objects.equals(this.active, timeOffPlan.active) && Objects.equals(this.metadata, timeOffPlan.metadata) && Objects.equals(this.selfUri, timeOffPlan.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.activityCodeIds, this.timeOffLimits, this.autoApprovalRule, this.daysBeforeStartToExpireFromWaitlist, this.hrisTimeOffType, this.active, this.metadata, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimeOffPlan {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    activityCodeIds: ").append(this.toIndentedString(this.activityCodeIds)).append("\n");
        sb.append("    timeOffLimits: ").append(this.toIndentedString(this.timeOffLimits)).append("\n");
        sb.append("    autoApprovalRule: ").append(this.toIndentedString((Object)this.autoApprovalRule)).append("\n");
        sb.append("    daysBeforeStartToExpireFromWaitlist: ").append(this.toIndentedString(this.daysBeforeStartToExpireFromWaitlist)).append("\n");
        sb.append("    hrisTimeOffType: ").append(this.toIndentedString(this.hrisTimeOffType)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AutoApprovalRuleEnumDeserializer.class)
    public static enum AutoApprovalRuleEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NEVER("Never"),
        ALWAYS("Always"),
        CHECKLIMITS("CheckLimits");

        private String value;

        private AutoApprovalRuleEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AutoApprovalRuleEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AutoApprovalRuleEnum value : AutoApprovalRuleEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AutoApprovalRuleEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AutoApprovalRuleEnumDeserializer
    extends StdDeserializer<AutoApprovalRuleEnum> {
        public AutoApprovalRuleEnumDeserializer() {
            super(AutoApprovalRuleEnumDeserializer.class);
        }

        public AutoApprovalRuleEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AutoApprovalRuleEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

