/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.ExternalDataSource;
import com.mypurecloud.sdk.v2.model.ExternalOrganization;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Relationship
implements Serializable {
    private String id = null;
    private User user = null;
    private ExternalOrganization externalOrganization = null;
    private String relationship = null;
    private List<ExternalDataSource> externalDataSources = new ArrayList<ExternalDataSource>();
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Relationship user(User user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The user associated with the external organization. When creating or updating a relationship, only User.id is required. User object is fully populated when expanding a note.")
    @JsonProperty(value="user")
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Relationship externalOrganization(ExternalOrganization externalOrganization) {
        this.externalOrganization = externalOrganization;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The external organization this relationship is attached to")
    @JsonProperty(value="externalOrganization")
    public ExternalOrganization getExternalOrganization() {
        return this.externalOrganization;
    }

    public void setExternalOrganization(ExternalOrganization externalOrganization) {
        this.externalOrganization = externalOrganization;
    }

    public Relationship relationship(String relationship) {
        this.relationship = relationship;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The relationship or role of the user to this external organization.Examples: Account Manager, Sales Engineer, Implementation Consultant")
    @JsonProperty(value="relationship")
    public String getRelationship() {
        return this.relationship;
    }

    public void setRelationship(String relationship) {
        this.relationship = relationship;
    }

    @ApiModelProperty(example="null", value="Links to the sources of data (e.g. one source might be a CRM) that contributed data to this record.  Read-only, and only populated when requested via expand param.")
    @JsonProperty(value="externalDataSources")
    public List<ExternalDataSource> getExternalDataSources() {
        return this.externalDataSources;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Relationship relationship = (Relationship)o;
        return Objects.equals(this.id, relationship.id) && Objects.equals(this.user, relationship.user) && Objects.equals(this.externalOrganization, relationship.externalOrganization) && Objects.equals(this.relationship, relationship.relationship) && Objects.equals(this.externalDataSources, relationship.externalDataSources) && Objects.equals(this.selfUri, relationship.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.user, this.externalOrganization, this.relationship, this.externalDataSources, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Relationship {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    externalOrganization: ").append(this.toIndentedString(this.externalOrganization)).append("\n");
        sb.append("    relationship: ").append(this.toIndentedString(this.relationship)).append("\n");
        sb.append("    externalDataSources: ").append(this.toIndentedString(this.externalDataSources)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

