/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.DefaultObjective;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MetricDefinition
implements Serializable {
    private String id = null;
    private String name = null;
    private UnitTypeEnum unitType = null;
    private String shortName = null;
    private List<String> dividendMetrics = new ArrayList<String>();
    private List<String> divisorMetrics = new ArrayList<String>();
    private DefaultObjective defaultObjective = null;
    private String lockTemplateId = null;
    private Boolean mediaTypeFilteringAllowed = null;
    private Boolean initialDirectionFilteringAllowed = null;
    private Boolean queueFilteringAllowed = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public MetricDefinition name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MetricDefinition unitType(UnitTypeEnum unitType) {
        this.unitType = unitType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of associated metric unit")
    @JsonProperty(value="unitType")
    public UnitTypeEnum getUnitType() {
        return this.unitType;
    }

    public void setUnitType(UnitTypeEnum unitType) {
        this.unitType = unitType;
    }

    public MetricDefinition shortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @ApiModelProperty(example="null", value="An alternate name for this metric definition, often abbreviation")
    @JsonProperty(value="shortName")
    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public MetricDefinition dividendMetrics(List<String> dividendMetrics) {
        this.dividendMetrics = dividendMetrics;
        return this;
    }

    @ApiModelProperty(example="null", value="Metric names used as dividend")
    @JsonProperty(value="dividendMetrics")
    public List<String> getDividendMetrics() {
        return this.dividendMetrics;
    }

    public void setDividendMetrics(List<String> dividendMetrics) {
        this.dividendMetrics = dividendMetrics;
    }

    public MetricDefinition divisorMetrics(List<String> divisorMetrics) {
        this.divisorMetrics = divisorMetrics;
        return this;
    }

    @ApiModelProperty(example="null", value="Metric names used as divisor")
    @JsonProperty(value="divisorMetrics")
    public List<String> getDivisorMetrics() {
        return this.divisorMetrics;
    }

    public void setDivisorMetrics(List<String> divisorMetrics) {
        this.divisorMetrics = divisorMetrics;
    }

    public MetricDefinition defaultObjective(DefaultObjective defaultObjective) {
        this.defaultObjective = defaultObjective;
        return this;
    }

    @ApiModelProperty(example="null", value="A predefined default objective for this metric")
    @JsonProperty(value="defaultObjective")
    public DefaultObjective getDefaultObjective() {
        return this.defaultObjective;
    }

    public void setDefaultObjective(DefaultObjective defaultObjective) {
        this.defaultObjective = defaultObjective;
    }

    public MetricDefinition lockTemplateId(String lockTemplateId) {
        this.lockTemplateId = lockTemplateId;
        return this;
    }

    @ApiModelProperty(example="null", value="An optional field to specify if this metric definition is locked to certain template. e.g. punctuality")
    @JsonProperty(value="lockTemplateId")
    public String getLockTemplateId() {
        return this.lockTemplateId;
    }

    public void setLockTemplateId(String lockTemplateId) {
        this.lockTemplateId = lockTemplateId;
    }

    public MetricDefinition mediaTypeFilteringAllowed(Boolean mediaTypeFilteringAllowed) {
        this.mediaTypeFilteringAllowed = mediaTypeFilteringAllowed;
        return this;
    }

    @ApiModelProperty(example="null", value="Flag to indicate if this metricDefinition allows filter based on media types")
    @JsonProperty(value="mediaTypeFilteringAllowed")
    public Boolean getMediaTypeFilteringAllowed() {
        return this.mediaTypeFilteringAllowed;
    }

    public void setMediaTypeFilteringAllowed(Boolean mediaTypeFilteringAllowed) {
        this.mediaTypeFilteringAllowed = mediaTypeFilteringAllowed;
    }

    public MetricDefinition initialDirectionFilteringAllowed(Boolean initialDirectionFilteringAllowed) {
        this.initialDirectionFilteringAllowed = initialDirectionFilteringAllowed;
        return this;
    }

    @ApiModelProperty(example="null", value="Flag to indicate if this metricDefinition allows filter based on initial direction")
    @JsonProperty(value="initialDirectionFilteringAllowed")
    public Boolean getInitialDirectionFilteringAllowed() {
        return this.initialDirectionFilteringAllowed;
    }

    public void setInitialDirectionFilteringAllowed(Boolean initialDirectionFilteringAllowed) {
        this.initialDirectionFilteringAllowed = initialDirectionFilteringAllowed;
    }

    public MetricDefinition queueFilteringAllowed(Boolean queueFilteringAllowed) {
        this.queueFilteringAllowed = queueFilteringAllowed;
        return this;
    }

    @ApiModelProperty(example="null", value="Flag to indicate if this metricDefinition allows filter based on queues")
    @JsonProperty(value="queueFilteringAllowed")
    public Boolean getQueueFilteringAllowed() {
        return this.queueFilteringAllowed;
    }

    public void setQueueFilteringAllowed(Boolean queueFilteringAllowed) {
        this.queueFilteringAllowed = queueFilteringAllowed;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricDefinition metricDefinition = (MetricDefinition)o;
        return Objects.equals(this.id, metricDefinition.id) && Objects.equals(this.name, metricDefinition.name) && Objects.equals((Object)this.unitType, (Object)metricDefinition.unitType) && Objects.equals(this.shortName, metricDefinition.shortName) && Objects.equals(this.dividendMetrics, metricDefinition.dividendMetrics) && Objects.equals(this.divisorMetrics, metricDefinition.divisorMetrics) && Objects.equals(this.defaultObjective, metricDefinition.defaultObjective) && Objects.equals(this.lockTemplateId, metricDefinition.lockTemplateId) && Objects.equals(this.mediaTypeFilteringAllowed, metricDefinition.mediaTypeFilteringAllowed) && Objects.equals(this.initialDirectionFilteringAllowed, metricDefinition.initialDirectionFilteringAllowed) && Objects.equals(this.queueFilteringAllowed, metricDefinition.queueFilteringAllowed) && Objects.equals(this.selfUri, metricDefinition.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.unitType, this.shortName, this.dividendMetrics, this.divisorMetrics, this.defaultObjective, this.lockTemplateId, this.mediaTypeFilteringAllowed, this.initialDirectionFilteringAllowed, this.queueFilteringAllowed, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricDefinition {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    unitType: ").append(this.toIndentedString((Object)this.unitType)).append("\n");
        sb.append("    shortName: ").append(this.toIndentedString(this.shortName)).append("\n");
        sb.append("    dividendMetrics: ").append(this.toIndentedString(this.dividendMetrics)).append("\n");
        sb.append("    divisorMetrics: ").append(this.toIndentedString(this.divisorMetrics)).append("\n");
        sb.append("    defaultObjective: ").append(this.toIndentedString(this.defaultObjective)).append("\n");
        sb.append("    lockTemplateId: ").append(this.toIndentedString(this.lockTemplateId)).append("\n");
        sb.append("    mediaTypeFilteringAllowed: ").append(this.toIndentedString(this.mediaTypeFilteringAllowed)).append("\n");
        sb.append("    initialDirectionFilteringAllowed: ").append(this.toIndentedString(this.initialDirectionFilteringAllowed)).append("\n");
        sb.append("    queueFilteringAllowed: ").append(this.toIndentedString(this.queueFilteringAllowed)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=UnitTypeEnumDeserializer.class)
    public static enum UnitTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NONE("None"),
        PERCENT("Percent"),
        CURRENCY("Currency"),
        SECONDS("Seconds"),
        NUMBER("Number"),
        ATTENDANCESTATUS("AttendanceStatus"),
        UNIT("Unit");

        private String value;

        private UnitTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static UnitTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (UnitTypeEnum value : UnitTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return UnitTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class UnitTypeEnumDeserializer
    extends StdDeserializer<UnitTypeEnum> {
        public UnitTypeEnumDeserializer() {
            super(UnitTypeEnumDeserializer.class);
        }

        public UnitTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return UnitTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

