/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class KnowledgeDocumentContentUpload
implements Serializable {
    private String id = null;
    private ContentTypeEnum contentType = null;
    private String fileName = null;
    private StatusEnum status = null;
    private String uploadKey = null;
    private String url = null;
    private Map<String, String> headers = null;
    private AddressableEntityRef document = null;
    private String errorMessage = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public KnowledgeDocumentContentUpload contentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Type of Article Content.")
    @JsonProperty(value="contentType")
    public ContentTypeEnum getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
    }

    public KnowledgeDocumentContentUpload fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Name of the file to upload. It must not start with a dot and not end with a forward slash. Whitespace and the following characters are not allowed: \\{^}%`]\">[~<#|")
    @JsonProperty(value="fileName")
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @ApiModelProperty(example="null", value="Status of the upload operation")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    @ApiModelProperty(example="null", value="Key that identifies the file in the storage including the file name")
    @JsonProperty(value="uploadKey")
    public String getUploadKey() {
        return this.uploadKey;
    }

    @ApiModelProperty(example="null", value="Presigned URL to PUT the file to")
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @ApiModelProperty(example="null", value="Required headers when uploading a file through PUT request to the URL")
    @JsonProperty(value="headers")
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @ApiModelProperty(example="null", value="ID of the document for which article content is to be uploaded")
    @JsonProperty(value="document")
    public AddressableEntityRef getDocument() {
        return this.document;
    }

    @ApiModelProperty(example="null", value="Error message when upload fails")
    @JsonProperty(value="errorMessage")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeDocumentContentUpload knowledgeDocumentContentUpload = (KnowledgeDocumentContentUpload)o;
        return Objects.equals(this.id, knowledgeDocumentContentUpload.id) && Objects.equals((Object)this.contentType, (Object)knowledgeDocumentContentUpload.contentType) && Objects.equals(this.fileName, knowledgeDocumentContentUpload.fileName) && Objects.equals((Object)this.status, (Object)knowledgeDocumentContentUpload.status) && Objects.equals(this.uploadKey, knowledgeDocumentContentUpload.uploadKey) && Objects.equals(this.url, knowledgeDocumentContentUpload.url) && Objects.equals(this.headers, knowledgeDocumentContentUpload.headers) && Objects.equals(this.document, knowledgeDocumentContentUpload.document) && Objects.equals(this.errorMessage, knowledgeDocumentContentUpload.errorMessage) && Objects.equals(this.selfUri, knowledgeDocumentContentUpload.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.contentType, this.fileName, this.status, this.uploadKey, this.url, this.headers, this.document, this.errorMessage, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeDocumentContentUpload {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString((Object)this.contentType)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    uploadKey: ").append(this.toIndentedString(this.uploadKey)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("    document: ").append(this.toIndentedString(this.document)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ContentTypeEnumDeserializer.class)
    public static enum ContentTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BODY("Body"),
        ATTACHMENT("Attachment");

        private String value;

        private ContentTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ContentTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ContentTypeEnum value : ContentTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ContentTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        VALIDATIONFAILED("ValidationFailed"),
        INPROGRESS("InProgress"),
        COMPLETED("Completed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class ContentTypeEnumDeserializer
    extends StdDeserializer<ContentTypeEnum> {
        public ContentTypeEnumDeserializer() {
            super(ContentTypeEnumDeserializer.class);
        }

        public ContentTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ContentTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

