/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.JourneyViewElement;
import com.mypurecloud.sdk.v2.model.JourneyViewUser;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A journey view")
public class JourneyView
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private Integer version = null;
    private JourneyViewUser createdBy = null;
    private JourneyViewUser modifiedBy = null;
    private String interval = null;
    private String duration = null;
    private List<JourneyViewElement> elements = new ArrayList<JourneyViewElement>();
    private Date dateCreated = null;
    private Date dateModified = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public JourneyView name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JourneyView description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="A description of the journey view")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(example="null", value="The version of the journey view")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    @ApiModelProperty(example="null", value="User that has created the view.")
    @JsonProperty(value="createdBy")
    public JourneyViewUser getCreatedBy() {
        return this.createdBy;
    }

    @ApiModelProperty(example="null", value="User that has modified the view.")
    @JsonProperty(value="modifiedBy")
    public JourneyViewUser getModifiedBy() {
        return this.modifiedBy;
    }

    public JourneyView interval(String interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="null", value="An absolute timeframe for the journey view, expressed as an ISO 8601 interval. Only one of interval or duration must be specified. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public JourneyView duration(String duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(example="null", value="A relative timeframe for the journey view, expressed as an ISO 8601 duration. Only one of interval or duration must be specified. Periods are represented as an ISO-8601 string. For example: P1D or P1DT12H")
    @JsonProperty(value="duration")
    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public JourneyView elements(List<JourneyViewElement> elements) {
        this.elements = elements;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The elements within the journey view")
    @JsonProperty(value="elements")
    public List<JourneyViewElement> getElements() {
        return this.elements;
    }

    public void setElements(List<JourneyViewElement> elements) {
        this.elements = elements;
    }

    @ApiModelProperty(example="null", value="The date when the journey view was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="The date when this version of the journey view was modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JourneyView journeyView = (JourneyView)o;
        return Objects.equals(this.id, journeyView.id) && Objects.equals(this.name, journeyView.name) && Objects.equals(this.description, journeyView.description) && Objects.equals(this.version, journeyView.version) && Objects.equals(this.createdBy, journeyView.createdBy) && Objects.equals(this.modifiedBy, journeyView.modifiedBy) && Objects.equals(this.interval, journeyView.interval) && Objects.equals(this.duration, journeyView.duration) && Objects.equals(this.elements, journeyView.elements) && Objects.equals(this.dateCreated, journeyView.dateCreated) && Objects.equals(this.dateModified, journeyView.dateModified) && Objects.equals(this.selfUri, journeyView.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.version, this.createdBy, this.modifiedBy, this.interval, this.duration, this.elements, this.dateCreated, this.dateModified, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JourneyView {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    elements: ").append(this.toIndentedString(this.elements)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

