/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.SupportedContentReference;
import com.mypurecloud.sdk.v2.model.WebDeploymentConfigurationVersionResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Details about a Web Deployment")
public class ExpandableWebDeployment
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private Boolean allowAllDomains = null;
    private List<String> allowedDomains = new ArrayList<String>();
    private SupportedContentReference supportedContent = null;
    private String snippet = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private AddressableEntityRef lastModifiedUser = null;
    private DomainEntityRef flow = null;
    private StatusEnum status = null;
    private WebDeploymentConfigurationVersionResponse _configuration = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The deployment ID")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public ExpandableWebDeployment name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The deployment name")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ExpandableWebDeployment description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of the config")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ExpandableWebDeployment allowAllDomains(Boolean allowAllDomains) {
        this.allowAllDomains = allowAllDomains;
        return this;
    }

    @ApiModelProperty(example="null", value="Property indicates whether all domains are allowed or not. allowedDomains must be empty when this is set as true.")
    @JsonProperty(value="allowAllDomains")
    public Boolean getAllowAllDomains() {
        return this.allowAllDomains;
    }

    public void setAllowAllDomains(Boolean allowAllDomains) {
        this.allowAllDomains = allowAllDomains;
    }

    public ExpandableWebDeployment allowedDomains(List<String> allowedDomains) {
        this.allowedDomains = allowedDomains;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of domains that are approved to use this deployment; the list will be added to CORS headers for ease of web use.")
    @JsonProperty(value="allowedDomains")
    public List<String> getAllowedDomains() {
        return this.allowedDomains;
    }

    public void setAllowedDomains(List<String> allowedDomains) {
        this.allowedDomains = allowedDomains;
    }

    public ExpandableWebDeployment supportedContent(SupportedContentReference supportedContent) {
        this.supportedContent = supportedContent;
        return this;
    }

    @ApiModelProperty(example="null", value="The supported content profile for a deployment")
    @JsonProperty(value="supportedContent")
    public SupportedContentReference getSupportedContent() {
        return this.supportedContent;
    }

    public void setSupportedContent(SupportedContentReference supportedContent) {
        this.supportedContent = supportedContent;
    }

    @ApiModelProperty(example="null", value="Javascript snippet used to load the config")
    @JsonProperty(value="snippet")
    public String getSnippet() {
        return this.snippet;
    }

    @ApiModelProperty(example="null", value="The date the deployment was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="The date the deployment was most recently modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="A reference to the user who most recently modified the deployment")
    @JsonProperty(value="lastModifiedUser")
    public AddressableEntityRef getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    public ExpandableWebDeployment flow(DomainEntityRef flow) {
        this.flow = flow;
        return this;
    }

    @ApiModelProperty(example="null", value="A reference to the inboundshortmessage flow used by this deployment")
    @JsonProperty(value="flow")
    public DomainEntityRef getFlow() {
        return this.flow;
    }

    public void setFlow(DomainEntityRef flow) {
        this.flow = flow;
    }

    public ExpandableWebDeployment status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The current status of the deployment")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ExpandableWebDeployment _configuration(WebDeploymentConfigurationVersionResponse _configuration) {
        this._configuration = _configuration;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The config version this deployment uses")
    @JsonProperty(value="configuration")
    public WebDeploymentConfigurationVersionResponse getConfiguration() {
        return this._configuration;
    }

    public void setConfiguration(WebDeploymentConfigurationVersionResponse _configuration) {
        this._configuration = _configuration;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpandableWebDeployment expandableWebDeployment = (ExpandableWebDeployment)o;
        return Objects.equals(this.id, expandableWebDeployment.id) && Objects.equals(this.name, expandableWebDeployment.name) && Objects.equals(this.description, expandableWebDeployment.description) && Objects.equals(this.allowAllDomains, expandableWebDeployment.allowAllDomains) && Objects.equals(this.allowedDomains, expandableWebDeployment.allowedDomains) && Objects.equals(this.supportedContent, expandableWebDeployment.supportedContent) && Objects.equals(this.snippet, expandableWebDeployment.snippet) && Objects.equals(this.dateCreated, expandableWebDeployment.dateCreated) && Objects.equals(this.dateModified, expandableWebDeployment.dateModified) && Objects.equals(this.lastModifiedUser, expandableWebDeployment.lastModifiedUser) && Objects.equals(this.flow, expandableWebDeployment.flow) && Objects.equals((Object)this.status, (Object)expandableWebDeployment.status) && Objects.equals(this._configuration, expandableWebDeployment._configuration) && Objects.equals(this.selfUri, expandableWebDeployment.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.allowAllDomains, this.allowedDomains, this.supportedContent, this.snippet, this.dateCreated, this.dateModified, this.lastModifiedUser, this.flow, this.status, this._configuration, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExpandableWebDeployment {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    allowAllDomains: ").append(this.toIndentedString(this.allowAllDomains)).append("\n");
        sb.append("    allowedDomains: ").append(this.toIndentedString(this.allowedDomains)).append("\n");
        sb.append("    supportedContent: ").append(this.toIndentedString(this.supportedContent)).append("\n");
        sb.append("    snippet: ").append(this.toIndentedString(this.snippet)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    lastModifiedUser: ").append(this.toIndentedString(this.lastModifiedUser)).append("\n");
        sb.append("    flow: ").append(this.toIndentedString(this.flow)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    _configuration: ").append(this.toIndentedString(this._configuration)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PENDING("Pending"),
        ACTIVE("Active"),
        INACTIVE("Inactive"),
        ERROR("Error"),
        DELETING("Deleting");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

