/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class Device
implements Serializable {
    private CategoryEnum category = null;
    private String type = null;
    private Boolean isMobile = null;
    private Integer screenHeight = null;
    private Integer screenWidth = null;
    private Integer screenDensity = null;
    private String fingerprint = null;
    private String osFamily = null;
    private String osVersion = null;
    private String manufacturer = null;

    public Device category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Device category.")
    @JsonProperty(value="category")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public Device type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Device type (e.g. iPad, iPhone, Other).")
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Device isMobile(Boolean isMobile) {
        this.isMobile = isMobile;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Flag that is true for mobile devices.")
    @JsonProperty(value="isMobile")
    public Boolean getIsMobile() {
        return this.isMobile;
    }

    public void setIsMobile(Boolean isMobile) {
        this.isMobile = isMobile;
    }

    public Device screenHeight(Integer screenHeight) {
        this.screenHeight = screenHeight;
        return this;
    }

    @ApiModelProperty(example="null", value="Device's screen height.")
    @JsonProperty(value="screenHeight")
    public Integer getScreenHeight() {
        return this.screenHeight;
    }

    public void setScreenHeight(Integer screenHeight) {
        this.screenHeight = screenHeight;
    }

    public Device screenWidth(Integer screenWidth) {
        this.screenWidth = screenWidth;
        return this;
    }

    @ApiModelProperty(example="null", value="Device's screen width.")
    @JsonProperty(value="screenWidth")
    public Integer getScreenWidth() {
        return this.screenWidth;
    }

    public void setScreenWidth(Integer screenWidth) {
        this.screenWidth = screenWidth;
    }

    public Device screenDensity(Integer screenDensity) {
        this.screenDensity = screenDensity;
        return this;
    }

    @ApiModelProperty(example="null", value="Device's screen density, measured as a scale factor where a value of 1 represents a baseline 1:1 ratio of pixels to logical (device-independent) pixels.")
    @JsonProperty(value="screenDensity")
    public Integer getScreenDensity() {
        return this.screenDensity;
    }

    public void setScreenDensity(Integer screenDensity) {
        this.screenDensity = screenDensity;
    }

    public Device fingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
        return this;
    }

    @ApiModelProperty(example="null", value="Fingerprint generated by looking at the individual device features.")
    @JsonProperty(value="fingerprint")
    public String getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public Device osFamily(String osFamily) {
        this.osFamily = osFamily;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Operating system family.")
    @JsonProperty(value="osFamily")
    public String getOsFamily() {
        return this.osFamily;
    }

    public void setOsFamily(String osFamily) {
        this.osFamily = osFamily;
    }

    public Device osVersion(String osVersion) {
        this.osVersion = osVersion;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Operating system version.")
    @JsonProperty(value="osVersion")
    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public Device manufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
        return this;
    }

    @ApiModelProperty(example="null", value="Manufacturer of the device.")
    @JsonProperty(value="manufacturer")
    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Device device = (Device)o;
        return Objects.equals((Object)this.category, (Object)device.category) && Objects.equals(this.type, device.type) && Objects.equals(this.isMobile, device.isMobile) && Objects.equals(this.screenHeight, device.screenHeight) && Objects.equals(this.screenWidth, device.screenWidth) && Objects.equals(this.screenDensity, device.screenDensity) && Objects.equals(this.fingerprint, device.fingerprint) && Objects.equals(this.osFamily, device.osFamily) && Objects.equals(this.osVersion, device.osVersion) && Objects.equals(this.manufacturer, device.manufacturer);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.category, this.type, this.isMobile, this.screenHeight, this.screenWidth, this.screenDensity, this.fingerprint, this.osFamily, this.osVersion, this.manufacturer});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Device {\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    isMobile: ").append(this.toIndentedString(this.isMobile)).append("\n");
        sb.append("    screenHeight: ").append(this.toIndentedString(this.screenHeight)).append("\n");
        sb.append("    screenWidth: ").append(this.toIndentedString(this.screenWidth)).append("\n");
        sb.append("    screenDensity: ").append(this.toIndentedString(this.screenDensity)).append("\n");
        sb.append("    fingerprint: ").append(this.toIndentedString(this.fingerprint)).append("\n");
        sb.append("    osFamily: ").append(this.toIndentedString(this.osFamily)).append("\n");
        sb.append("    osVersion: ").append(this.toIndentedString(this.osVersion)).append("\n");
        sb.append("    manufacturer: ").append(this.toIndentedString(this.manufacturer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=CategoryEnumDeserializer.class)
    public static enum CategoryEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DESKTOP("desktop"),
        MOBILE("mobile"),
        TABLET("tablet"),
        OTHER("other");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CategoryEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CategoryEnum value : CategoryEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CategoryEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CategoryEnumDeserializer
    extends StdDeserializer<CategoryEnum> {
        public CategoryEnumDeserializer() {
            super(CategoryEnumDeserializer.class);
        }

        public CategoryEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CategoryEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

