/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Criteria
implements Serializable {
    private String key = null;
    private List<String> values = new ArrayList<String>();
    private Boolean shouldIgnoreCase = null;
    private OperatorEnum operator = null;

    public Criteria key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The criteria key.")
    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Criteria values(List<String> values) {
        this.values = values;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The criteria values.")
    @JsonProperty(value="values")
    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public Criteria shouldIgnoreCase(Boolean shouldIgnoreCase) {
        this.shouldIgnoreCase = shouldIgnoreCase;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Should criteria be case insensitive.")
    @JsonProperty(value="shouldIgnoreCase")
    public Boolean getShouldIgnoreCase() {
        return this.shouldIgnoreCase;
    }

    public void setShouldIgnoreCase(Boolean shouldIgnoreCase) {
        this.shouldIgnoreCase = shouldIgnoreCase;
    }

    public Criteria operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The comparison operator.")
    @JsonProperty(value="operator")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Criteria criteria = (Criteria)o;
        return Objects.equals(this.key, criteria.key) && Objects.equals(this.values, criteria.values) && Objects.equals(this.shouldIgnoreCase, criteria.shouldIgnoreCase) && Objects.equals((Object)this.operator, (Object)criteria.operator);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.values, this.shouldIgnoreCase, this.operator});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Criteria {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("    shouldIgnoreCase: ").append(this.toIndentedString(this.shouldIgnoreCase)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=OperatorEnumDeserializer.class)
    public static enum OperatorEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CONTAINSALL("containsAll"),
        CONTAINSANY("containsAny"),
        NOTCONTAINSALL("notContainsAll"),
        NOTCONTAINSANY("notContainsAny"),
        EQUAL("equal"),
        NOTEQUAL("notEqual"),
        GREATERTHAN("greaterThan"),
        GREATERTHANOREQUAL("greaterThanOrEqual"),
        LESSTHAN("lessThan"),
        LESSTHANOREQUAL("lessThanOrEqual"),
        STARTSWITH("startsWith"),
        ENDSWITH("endsWith");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OperatorEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OperatorEnum value : OperatorEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OperatorEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OperatorEnumDeserializer
    extends StdDeserializer<OperatorEnum> {
        public OperatorEnumDeserializer() {
            super(OperatorEnumDeserializer.class);
        }

        public OperatorEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OperatorEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

