/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.MemberGroup;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ConditionalGroupRoutingRule
implements Serializable {
    private DomainEntityRef queue = null;
    private MetricEnum metric = null;
    private OperatorEnum operator = null;
    private Double conditionValue = null;
    private List<MemberGroup> groups = new ArrayList<MemberGroup>();
    private Integer waitSeconds = null;

    public ConditionalGroupRoutingRule queue(DomainEntityRef queue) {
        this.queue = queue;
        return this;
    }

    @ApiModelProperty(example="null", value="The queue being evaluated for this rule.  For rule 1, this is always the current queue, so should not be specified.")
    @JsonProperty(value="queue")
    public DomainEntityRef getQueue() {
        return this.queue;
    }

    public void setQueue(DomainEntityRef queue) {
        this.queue = queue;
    }

    public ConditionalGroupRoutingRule metric(MetricEnum metric) {
        this.metric = metric;
        return this;
    }

    @ApiModelProperty(example="null", value="The queue metric being evaluated")
    @JsonProperty(value="metric")
    public MetricEnum getMetric() {
        return this.metric;
    }

    public void setMetric(MetricEnum metric) {
        this.metric = metric;
    }

    public ConditionalGroupRoutingRule operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(example="null", value="The operator that compares the actual value against the condition value")
    @JsonProperty(value="operator")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public ConditionalGroupRoutingRule conditionValue(Double conditionValue) {
        this.conditionValue = conditionValue;
        return this;
    }

    @ApiModelProperty(example="null", value="The limit value, beyond which a rule evaluates as true")
    @JsonProperty(value="conditionValue")
    public Double getConditionValue() {
        return this.conditionValue;
    }

    public void setConditionValue(Double conditionValue) {
        this.conditionValue = conditionValue;
    }

    public ConditionalGroupRoutingRule groups(List<MemberGroup> groups) {
        this.groups = groups;
        return this;
    }

    @ApiModelProperty(example="null", value="The group(s) to activate if the rule evaluates as true")
    @JsonProperty(value="groups")
    public List<MemberGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(List<MemberGroup> groups) {
        this.groups = groups;
    }

    public ConditionalGroupRoutingRule waitSeconds(Integer waitSeconds) {
        this.waitSeconds = waitSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of seconds to wait in this rule, if it evaluates as true, before evaluating the next rule.  For the final rule, this is ignored, so need not be specified.")
    @JsonProperty(value="waitSeconds")
    public Integer getWaitSeconds() {
        return this.waitSeconds;
    }

    public void setWaitSeconds(Integer waitSeconds) {
        this.waitSeconds = waitSeconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionalGroupRoutingRule conditionalGroupRoutingRule = (ConditionalGroupRoutingRule)o;
        return Objects.equals(this.queue, conditionalGroupRoutingRule.queue) && Objects.equals((Object)this.metric, (Object)conditionalGroupRoutingRule.metric) && Objects.equals((Object)this.operator, (Object)conditionalGroupRoutingRule.operator) && Objects.equals(this.conditionValue, conditionalGroupRoutingRule.conditionValue) && Objects.equals(this.groups, conditionalGroupRoutingRule.groups) && Objects.equals(this.waitSeconds, conditionalGroupRoutingRule.waitSeconds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.queue, this.metric, this.operator, this.conditionValue, this.groups, this.waitSeconds});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConditionalGroupRoutingRule {\n");
        sb.append("    queue: ").append(this.toIndentedString(this.queue)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString((Object)this.metric)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    conditionValue: ").append(this.toIndentedString(this.conditionValue)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    waitSeconds: ").append(this.toIndentedString(this.waitSeconds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MetricEnumDeserializer.class)
    public static enum MetricEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ESTIMATEDWAITTIME("EstimatedWaitTime"),
        SERVICELEVEL("ServiceLevel");

        private String value;

        private MetricEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MetricEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MetricEnum value : MetricEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MetricEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=OperatorEnumDeserializer.class)
    public static enum OperatorEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        GREATERTHAN("GreaterThan"),
        GREATERTHANOREQUALTO("GreaterThanOrEqualTo"),
        LESSTHAN("LessThan"),
        LESSTHANOREQUALTO("LessThanOrEqualTo");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OperatorEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OperatorEnum value : OperatorEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OperatorEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OperatorEnumDeserializer
    extends StdDeserializer<OperatorEnum> {
        public OperatorEnumDeserializer() {
            super(OperatorEnumDeserializer.class);
        }

        public OperatorEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OperatorEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class MetricEnumDeserializer
    extends StdDeserializer<MetricEnum> {
        public MetricEnumDeserializer() {
            super(MetricEnumDeserializer.class);
        }

        public MetricEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MetricEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

