/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CannedResponseLibraries
implements Serializable {
    private List<String> libraryIds = new ArrayList<String>();
    private ModeEnum mode = null;

    public CannedResponseLibraries libraryIds(List<String> libraryIds) {
        this.libraryIds = libraryIds;
        return this;
    }

    @ApiModelProperty(example="null", value="Set of canned response library IDs associated with the queue only when mode is SelectedOnly.")
    @JsonProperty(value="libraryIds")
    public List<String> getLibraryIds() {
        return this.libraryIds;
    }

    public void setLibraryIds(List<String> libraryIds) {
        this.libraryIds = libraryIds;
    }

    public CannedResponseLibraries mode(ModeEnum mode) {
        this.mode = mode;
        return this;
    }

    @ApiModelProperty(example="null", value="The association mode of canned response libraries to queue")
    @JsonProperty(value="mode")
    public ModeEnum getMode() {
        return this.mode;
    }

    public void setMode(ModeEnum mode) {
        this.mode = mode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CannedResponseLibraries cannedResponseLibraries = (CannedResponseLibraries)o;
        return Objects.equals(this.libraryIds, cannedResponseLibraries.libraryIds) && Objects.equals((Object)this.mode, (Object)cannedResponseLibraries.mode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.libraryIds, this.mode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CannedResponseLibraries {\n");
        sb.append("    libraryIds: ").append(this.toIndentedString(this.libraryIds)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ModeEnumDeserializer.class)
    public static enum ModeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALL("All"),
        SELECTEDONLY("SelectedOnly"),
        NONE("None");

        private String value;

        private ModeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ModeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ModeEnum value : ModeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ModeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ModeEnumDeserializer
    extends StdDeserializer<ModeEnum> {
        public ModeEnumDeserializer() {
            super(ModeEnumDeserializer.class);
        }

        public ModeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ModeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

