/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ConversationRoutingData;
import com.mypurecloud.sdk.v2.model.DialerPreview;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.ErrorInfo;
import com.mypurecloud.sdk.v2.model.JourneyContext;
import com.mypurecloud.sdk.v2.model.Voicemail;
import com.mypurecloud.sdk.v2.model.Wrapup;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CallbackMediaParticipant
implements Serializable {
    private String id = null;
    private String name = null;
    private String address = null;
    private Date startTime = null;
    private Date connectedTime = null;
    private Date endTime = null;
    private Date startHoldTime = null;
    private String purpose = null;
    private StateEnum state = null;
    private DirectionEnum direction = null;
    private DisconnectTypeEnum disconnectType = null;
    private Boolean held = null;
    private Boolean wrapupRequired = null;
    private String wrapupPrompt = null;
    private List<String> mediaRoles = new ArrayList<String>();
    private DomainEntityRef user = null;
    private DomainEntityRef queue = null;
    private DomainEntityRef team = null;
    private Map<String, String> attributes = null;
    private ErrorInfo errorInfo = null;
    private DomainEntityRef script = null;
    private Integer wrapupTimeoutMs = null;
    private Boolean wrapupSkipped = null;
    private Integer alertingTimeoutMs = null;
    private String provider = null;
    private DomainEntityRef externalContact = null;
    private DomainEntityRef externalOrganization = null;
    private Wrapup wrapup = null;
    private String peer = null;
    private FlaggedReasonEnum flaggedReason = null;
    private JourneyContext journeyContext = null;
    private ConversationRoutingData conversationRoutingData = null;
    private Date startAcwTime = null;
    private Date endAcwTime = null;
    private DialerPreview outboundPreview = null;
    private Voicemail voicemail = null;
    private List<String> callbackNumbers = new ArrayList<String>();
    private String callbackUserName = null;
    private Boolean externalCampaign = null;
    private Boolean skipEnabled = null;
    private Integer timeoutSeconds = null;
    private String automatedCallbackConfigId = null;
    private Date callbackScheduledTime = null;

    public CallbackMediaParticipant id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="The unique participant ID.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CallbackMediaParticipant name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The display friendly name of the participant.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CallbackMediaParticipant address(String address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(example="null", value="The participant address.")
    @JsonProperty(value="address")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public CallbackMediaParticipant startTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when this participant first joined the conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startTime")
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public CallbackMediaParticipant connectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when this participant went connected for this media (eg: video connected time). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="connectedTime")
    public Date getConnectedTime() {
        return this.connectedTime;
    }

    public void setConnectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
    }

    public CallbackMediaParticipant endTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when this participant went disconnected for this media (eg: video disconnected time). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="endTime")
    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public CallbackMediaParticipant startHoldTime(Date startHoldTime) {
        this.startHoldTime = startHoldTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when this participant's hold started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startHoldTime")
    public Date getStartHoldTime() {
        return this.startHoldTime;
    }

    public void setStartHoldTime(Date startHoldTime) {
        this.startHoldTime = startHoldTime;
    }

    public CallbackMediaParticipant purpose(String purpose) {
        this.purpose = purpose;
        return this;
    }

    @ApiModelProperty(example="null", value="The participant's purpose.  Values can be: 'agent', 'user', 'customer', 'external', 'acd', 'ivr")
    @JsonProperty(value="purpose")
    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public CallbackMediaParticipant state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The participant's state.  Values can be: 'alerting', 'connected', 'disconnected', 'dialing', 'contacting")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public CallbackMediaParticipant direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", value="The participant's direction.  Values can be: 'inbound' or 'outbound'")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public CallbackMediaParticipant disconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
        return this;
    }

    @ApiModelProperty(example="null", value="The reason the participant was disconnected from the conversation.")
    @JsonProperty(value="disconnectType")
    public DisconnectTypeEnum getDisconnectType() {
        return this.disconnectType;
    }

    public void setDisconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
    }

    public CallbackMediaParticipant held(Boolean held) {
        this.held = held;
        return this;
    }

    @ApiModelProperty(example="null", value="Value is true when the participant is on hold.")
    @JsonProperty(value="held")
    public Boolean getHeld() {
        return this.held;
    }

    public void setHeld(Boolean held) {
        this.held = held;
    }

    public CallbackMediaParticipant wrapupRequired(Boolean wrapupRequired) {
        this.wrapupRequired = wrapupRequired;
        return this;
    }

    @ApiModelProperty(example="null", value="Value is true when the participant requires wrap-up.")
    @JsonProperty(value="wrapupRequired")
    public Boolean getWrapupRequired() {
        return this.wrapupRequired;
    }

    public void setWrapupRequired(Boolean wrapupRequired) {
        this.wrapupRequired = wrapupRequired;
    }

    public CallbackMediaParticipant wrapupPrompt(String wrapupPrompt) {
        this.wrapupPrompt = wrapupPrompt;
        return this;
    }

    @ApiModelProperty(example="null", value="The wrap-up prompt indicating the type of wrap-up to be performed.")
    @JsonProperty(value="wrapupPrompt")
    public String getWrapupPrompt() {
        return this.wrapupPrompt;
    }

    public void setWrapupPrompt(String wrapupPrompt) {
        this.wrapupPrompt = wrapupPrompt;
    }

    public CallbackMediaParticipant mediaRoles(List<String> mediaRoles) {
        this.mediaRoles = mediaRoles;
        return this;
    }

    @ApiModelProperty(example="null", value="List of roles this participant's media has had on the conversation, ie monitor, coach, etc")
    @JsonProperty(value="mediaRoles")
    public List<String> getMediaRoles() {
        return this.mediaRoles;
    }

    public void setMediaRoles(List<String> mediaRoles) {
        this.mediaRoles = mediaRoles;
    }

    public CallbackMediaParticipant user(DomainEntityRef user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="The PureCloud user for this participant.")
    @JsonProperty(value="user")
    public DomainEntityRef getUser() {
        return this.user;
    }

    public void setUser(DomainEntityRef user) {
        this.user = user;
    }

    public CallbackMediaParticipant queue(DomainEntityRef queue) {
        this.queue = queue;
        return this;
    }

    @ApiModelProperty(example="null", value="The PureCloud queue for this participant.")
    @JsonProperty(value="queue")
    public DomainEntityRef getQueue() {
        return this.queue;
    }

    public void setQueue(DomainEntityRef queue) {
        this.queue = queue;
    }

    public CallbackMediaParticipant team(DomainEntityRef team) {
        this.team = team;
        return this;
    }

    @ApiModelProperty(example="null", value="The PureCloud team for this participant.")
    @JsonProperty(value="team")
    public DomainEntityRef getTeam() {
        return this.team;
    }

    public void setTeam(DomainEntityRef team) {
        this.team = team;
    }

    public CallbackMediaParticipant attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of ad-hoc attributes for the participant.")
    @JsonProperty(value="attributes")
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public CallbackMediaParticipant errorInfo(ErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="If the conversation ends in error, contains additional error details.")
    @JsonProperty(value="errorInfo")
    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    public void setErrorInfo(ErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
    }

    public CallbackMediaParticipant script(DomainEntityRef script) {
        this.script = script;
        return this;
    }

    @ApiModelProperty(example="null", value="The Engage script that should be used by this participant.")
    @JsonProperty(value="script")
    public DomainEntityRef getScript() {
        return this.script;
    }

    public void setScript(DomainEntityRef script) {
        this.script = script;
    }

    public CallbackMediaParticipant wrapupTimeoutMs(Integer wrapupTimeoutMs) {
        this.wrapupTimeoutMs = wrapupTimeoutMs;
        return this;
    }

    @ApiModelProperty(example="null", value="The amount of time the participant has to complete wrap-up.")
    @JsonProperty(value="wrapupTimeoutMs")
    public Integer getWrapupTimeoutMs() {
        return this.wrapupTimeoutMs;
    }

    public void setWrapupTimeoutMs(Integer wrapupTimeoutMs) {
        this.wrapupTimeoutMs = wrapupTimeoutMs;
    }

    public CallbackMediaParticipant wrapupSkipped(Boolean wrapupSkipped) {
        this.wrapupSkipped = wrapupSkipped;
        return this;
    }

    @ApiModelProperty(example="null", value="Value is true when the participant has skipped wrap-up.")
    @JsonProperty(value="wrapupSkipped")
    public Boolean getWrapupSkipped() {
        return this.wrapupSkipped;
    }

    public void setWrapupSkipped(Boolean wrapupSkipped) {
        this.wrapupSkipped = wrapupSkipped;
    }

    public CallbackMediaParticipant alertingTimeoutMs(Integer alertingTimeoutMs) {
        this.alertingTimeoutMs = alertingTimeoutMs;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies how long the agent has to answer an interaction before being marked as not responding.")
    @JsonProperty(value="alertingTimeoutMs")
    public Integer getAlertingTimeoutMs() {
        return this.alertingTimeoutMs;
    }

    public void setAlertingTimeoutMs(Integer alertingTimeoutMs) {
        this.alertingTimeoutMs = alertingTimeoutMs;
    }

    public CallbackMediaParticipant provider(String provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(example="null", value="The source provider for the communication.")
    @JsonProperty(value="provider")
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public CallbackMediaParticipant externalContact(DomainEntityRef externalContact) {
        this.externalContact = externalContact;
        return this;
    }

    @ApiModelProperty(example="null", value="If this participant represents an external contact, then this will be the reference for the external contact.")
    @JsonProperty(value="externalContact")
    public DomainEntityRef getExternalContact() {
        return this.externalContact;
    }

    public void setExternalContact(DomainEntityRef externalContact) {
        this.externalContact = externalContact;
    }

    public CallbackMediaParticipant externalOrganization(DomainEntityRef externalOrganization) {
        this.externalOrganization = externalOrganization;
        return this;
    }

    @ApiModelProperty(example="null", value="If this participant represents an external org, then this will be the reference for the external org.")
    @JsonProperty(value="externalOrganization")
    public DomainEntityRef getExternalOrganization() {
        return this.externalOrganization;
    }

    public void setExternalOrganization(DomainEntityRef externalOrganization) {
        this.externalOrganization = externalOrganization;
    }

    public CallbackMediaParticipant wrapup(Wrapup wrapup) {
        this.wrapup = wrapup;
        return this;
    }

    @ApiModelProperty(example="null", value="Wrapup for this participant, if it has been applied.")
    @JsonProperty(value="wrapup")
    public Wrapup getWrapup() {
        return this.wrapup;
    }

    public void setWrapup(Wrapup wrapup) {
        this.wrapup = wrapup;
    }

    public CallbackMediaParticipant peer(String peer) {
        this.peer = peer;
        return this;
    }

    @ApiModelProperty(example="null", value="The peer communication corresponding to a matching leg for this communication.")
    @JsonProperty(value="peer")
    public String getPeer() {
        return this.peer;
    }

    public void setPeer(String peer) {
        this.peer = peer;
    }

    public CallbackMediaParticipant flaggedReason(FlaggedReasonEnum flaggedReason) {
        this.flaggedReason = flaggedReason;
        return this;
    }

    @ApiModelProperty(example="null", value="The reason specifying why participant flagged the conversation.")
    @JsonProperty(value="flaggedReason")
    public FlaggedReasonEnum getFlaggedReason() {
        return this.flaggedReason;
    }

    public void setFlaggedReason(FlaggedReasonEnum flaggedReason) {
        this.flaggedReason = flaggedReason;
    }

    public CallbackMediaParticipant journeyContext(JourneyContext journeyContext) {
        this.journeyContext = journeyContext;
        return this;
    }

    @ApiModelProperty(example="null", value="Journey System data/context that is applicable to this communication.  When used for historical purposes, the context should be immutable.  When null, there is no applicable Journey System context.")
    @JsonProperty(value="journeyContext")
    public JourneyContext getJourneyContext() {
        return this.journeyContext;
    }

    public void setJourneyContext(JourneyContext journeyContext) {
        this.journeyContext = journeyContext;
    }

    public CallbackMediaParticipant conversationRoutingData(ConversationRoutingData conversationRoutingData) {
        this.conversationRoutingData = conversationRoutingData;
        return this;
    }

    @ApiModelProperty(example="null", value="Information on how a communication should be routed to an agent.")
    @JsonProperty(value="conversationRoutingData")
    public ConversationRoutingData getConversationRoutingData() {
        return this.conversationRoutingData;
    }

    public void setConversationRoutingData(ConversationRoutingData conversationRoutingData) {
        this.conversationRoutingData = conversationRoutingData;
    }

    public CallbackMediaParticipant startAcwTime(Date startAcwTime) {
        this.startAcwTime = startAcwTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this participant started after-call work. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startAcwTime")
    public Date getStartAcwTime() {
        return this.startAcwTime;
    }

    public void setStartAcwTime(Date startAcwTime) {
        this.startAcwTime = startAcwTime;
    }

    public CallbackMediaParticipant endAcwTime(Date endAcwTime) {
        this.endAcwTime = endAcwTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this participant ended after-call work. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="endAcwTime")
    public Date getEndAcwTime() {
        return this.endAcwTime;
    }

    public void setEndAcwTime(Date endAcwTime) {
        this.endAcwTime = endAcwTime;
    }

    public CallbackMediaParticipant outboundPreview(DialerPreview outboundPreview) {
        this.outboundPreview = outboundPreview;
        return this;
    }

    @ApiModelProperty(example="null", value="The outbound preview associated with this callback.")
    @JsonProperty(value="outboundPreview")
    public DialerPreview getOutboundPreview() {
        return this.outboundPreview;
    }

    public void setOutboundPreview(DialerPreview outboundPreview) {
        this.outboundPreview = outboundPreview;
    }

    public CallbackMediaParticipant voicemail(Voicemail voicemail) {
        this.voicemail = voicemail;
        return this;
    }

    @ApiModelProperty(example="null", value="The voicemail associated with this callback.")
    @JsonProperty(value="voicemail")
    public Voicemail getVoicemail() {
        return this.voicemail;
    }

    public void setVoicemail(Voicemail voicemail) {
        this.voicemail = voicemail;
    }

    public CallbackMediaParticipant callbackNumbers(List<String> callbackNumbers) {
        this.callbackNumbers = callbackNumbers;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of phone number to use for this callback.")
    @JsonProperty(value="callbackNumbers")
    public List<String> getCallbackNumbers() {
        return this.callbackNumbers;
    }

    public void setCallbackNumbers(List<String> callbackNumbers) {
        this.callbackNumbers = callbackNumbers;
    }

    public CallbackMediaParticipant callbackUserName(String callbackUserName) {
        this.callbackUserName = callbackUserName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the callback target.")
    @JsonProperty(value="callbackUserName")
    public String getCallbackUserName() {
        return this.callbackUserName;
    }

    public void setCallbackUserName(String callbackUserName) {
        this.callbackUserName = callbackUserName;
    }

    public CallbackMediaParticipant externalCampaign(Boolean externalCampaign) {
        this.externalCampaign = externalCampaign;
        return this;
    }

    @ApiModelProperty(example="null", value="True if the call for the callback uses external dialing.")
    @JsonProperty(value="externalCampaign")
    public Boolean getExternalCampaign() {
        return this.externalCampaign;
    }

    public void setExternalCampaign(Boolean externalCampaign) {
        this.externalCampaign = externalCampaign;
    }

    public CallbackMediaParticipant skipEnabled(Boolean skipEnabled) {
        this.skipEnabled = skipEnabled;
        return this;
    }

    @ApiModelProperty(example="null", value="If true, the callback can be skipped.")
    @JsonProperty(value="skipEnabled")
    public Boolean getSkipEnabled() {
        return this.skipEnabled;
    }

    public void setSkipEnabled(Boolean skipEnabled) {
        this.skipEnabled = skipEnabled;
    }

    public CallbackMediaParticipant timeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="Duration in seconds before the callback will be auto-dialed.")
    @JsonProperty(value="timeoutSeconds")
    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public CallbackMediaParticipant automatedCallbackConfigId(String automatedCallbackConfigId) {
        this.automatedCallbackConfigId = automatedCallbackConfigId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the config for automatically placing the callback (and handling the disposition). If absent, the callback will not be placed automatically but routed to an agent as per normal.")
    @JsonProperty(value="automatedCallbackConfigId")
    public String getAutomatedCallbackConfigId() {
        return this.automatedCallbackConfigId;
    }

    public void setAutomatedCallbackConfigId(String automatedCallbackConfigId) {
        this.automatedCallbackConfigId = automatedCallbackConfigId;
    }

    public CallbackMediaParticipant callbackScheduledTime(Date callbackScheduledTime) {
        this.callbackScheduledTime = callbackScheduledTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="callbackScheduledTime")
    public Date getCallbackScheduledTime() {
        return this.callbackScheduledTime;
    }

    public void setCallbackScheduledTime(Date callbackScheduledTime) {
        this.callbackScheduledTime = callbackScheduledTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallbackMediaParticipant callbackMediaParticipant = (CallbackMediaParticipant)o;
        return Objects.equals(this.id, callbackMediaParticipant.id) && Objects.equals(this.name, callbackMediaParticipant.name) && Objects.equals(this.address, callbackMediaParticipant.address) && Objects.equals(this.startTime, callbackMediaParticipant.startTime) && Objects.equals(this.connectedTime, callbackMediaParticipant.connectedTime) && Objects.equals(this.endTime, callbackMediaParticipant.endTime) && Objects.equals(this.startHoldTime, callbackMediaParticipant.startHoldTime) && Objects.equals(this.purpose, callbackMediaParticipant.purpose) && Objects.equals((Object)this.state, (Object)callbackMediaParticipant.state) && Objects.equals((Object)this.direction, (Object)callbackMediaParticipant.direction) && Objects.equals((Object)this.disconnectType, (Object)callbackMediaParticipant.disconnectType) && Objects.equals(this.held, callbackMediaParticipant.held) && Objects.equals(this.wrapupRequired, callbackMediaParticipant.wrapupRequired) && Objects.equals(this.wrapupPrompt, callbackMediaParticipant.wrapupPrompt) && Objects.equals(this.mediaRoles, callbackMediaParticipant.mediaRoles) && Objects.equals(this.user, callbackMediaParticipant.user) && Objects.equals(this.queue, callbackMediaParticipant.queue) && Objects.equals(this.team, callbackMediaParticipant.team) && Objects.equals(this.attributes, callbackMediaParticipant.attributes) && Objects.equals(this.errorInfo, callbackMediaParticipant.errorInfo) && Objects.equals(this.script, callbackMediaParticipant.script) && Objects.equals(this.wrapupTimeoutMs, callbackMediaParticipant.wrapupTimeoutMs) && Objects.equals(this.wrapupSkipped, callbackMediaParticipant.wrapupSkipped) && Objects.equals(this.alertingTimeoutMs, callbackMediaParticipant.alertingTimeoutMs) && Objects.equals(this.provider, callbackMediaParticipant.provider) && Objects.equals(this.externalContact, callbackMediaParticipant.externalContact) && Objects.equals(this.externalOrganization, callbackMediaParticipant.externalOrganization) && Objects.equals(this.wrapup, callbackMediaParticipant.wrapup) && Objects.equals(this.peer, callbackMediaParticipant.peer) && Objects.equals((Object)this.flaggedReason, (Object)callbackMediaParticipant.flaggedReason) && Objects.equals(this.journeyContext, callbackMediaParticipant.journeyContext) && Objects.equals(this.conversationRoutingData, callbackMediaParticipant.conversationRoutingData) && Objects.equals(this.startAcwTime, callbackMediaParticipant.startAcwTime) && Objects.equals(this.endAcwTime, callbackMediaParticipant.endAcwTime) && Objects.equals(this.outboundPreview, callbackMediaParticipant.outboundPreview) && Objects.equals(this.voicemail, callbackMediaParticipant.voicemail) && Objects.equals(this.callbackNumbers, callbackMediaParticipant.callbackNumbers) && Objects.equals(this.callbackUserName, callbackMediaParticipant.callbackUserName) && Objects.equals(this.externalCampaign, callbackMediaParticipant.externalCampaign) && Objects.equals(this.skipEnabled, callbackMediaParticipant.skipEnabled) && Objects.equals(this.timeoutSeconds, callbackMediaParticipant.timeoutSeconds) && Objects.equals(this.automatedCallbackConfigId, callbackMediaParticipant.automatedCallbackConfigId) && Objects.equals(this.callbackScheduledTime, callbackMediaParticipant.callbackScheduledTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.address, this.startTime, this.connectedTime, this.endTime, this.startHoldTime, this.purpose, this.state, this.direction, this.disconnectType, this.held, this.wrapupRequired, this.wrapupPrompt, this.mediaRoles, this.user, this.queue, this.team, this.attributes, this.errorInfo, this.script, this.wrapupTimeoutMs, this.wrapupSkipped, this.alertingTimeoutMs, this.provider, this.externalContact, this.externalOrganization, this.wrapup, this.peer, this.flaggedReason, this.journeyContext, this.conversationRoutingData, this.startAcwTime, this.endAcwTime, this.outboundPreview, this.voicemail, this.callbackNumbers, this.callbackUserName, this.externalCampaign, this.skipEnabled, this.timeoutSeconds, this.automatedCallbackConfigId, this.callbackScheduledTime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CallbackMediaParticipant {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    connectedTime: ").append(this.toIndentedString(this.connectedTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    startHoldTime: ").append(this.toIndentedString(this.startHoldTime)).append("\n");
        sb.append("    purpose: ").append(this.toIndentedString(this.purpose)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    disconnectType: ").append(this.toIndentedString((Object)this.disconnectType)).append("\n");
        sb.append("    held: ").append(this.toIndentedString(this.held)).append("\n");
        sb.append("    wrapupRequired: ").append(this.toIndentedString(this.wrapupRequired)).append("\n");
        sb.append("    wrapupPrompt: ").append(this.toIndentedString(this.wrapupPrompt)).append("\n");
        sb.append("    mediaRoles: ").append(this.toIndentedString(this.mediaRoles)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    queue: ").append(this.toIndentedString(this.queue)).append("\n");
        sb.append("    team: ").append(this.toIndentedString(this.team)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    errorInfo: ").append(this.toIndentedString(this.errorInfo)).append("\n");
        sb.append("    script: ").append(this.toIndentedString(this.script)).append("\n");
        sb.append("    wrapupTimeoutMs: ").append(this.toIndentedString(this.wrapupTimeoutMs)).append("\n");
        sb.append("    wrapupSkipped: ").append(this.toIndentedString(this.wrapupSkipped)).append("\n");
        sb.append("    alertingTimeoutMs: ").append(this.toIndentedString(this.alertingTimeoutMs)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    externalContact: ").append(this.toIndentedString(this.externalContact)).append("\n");
        sb.append("    externalOrganization: ").append(this.toIndentedString(this.externalOrganization)).append("\n");
        sb.append("    wrapup: ").append(this.toIndentedString(this.wrapup)).append("\n");
        sb.append("    peer: ").append(this.toIndentedString(this.peer)).append("\n");
        sb.append("    flaggedReason: ").append(this.toIndentedString((Object)this.flaggedReason)).append("\n");
        sb.append("    journeyContext: ").append(this.toIndentedString(this.journeyContext)).append("\n");
        sb.append("    conversationRoutingData: ").append(this.toIndentedString(this.conversationRoutingData)).append("\n");
        sb.append("    startAcwTime: ").append(this.toIndentedString(this.startAcwTime)).append("\n");
        sb.append("    endAcwTime: ").append(this.toIndentedString(this.endAcwTime)).append("\n");
        sb.append("    outboundPreview: ").append(this.toIndentedString(this.outboundPreview)).append("\n");
        sb.append("    voicemail: ").append(this.toIndentedString(this.voicemail)).append("\n");
        sb.append("    callbackNumbers: ").append(this.toIndentedString(this.callbackNumbers)).append("\n");
        sb.append("    callbackUserName: ").append(this.toIndentedString(this.callbackUserName)).append("\n");
        sb.append("    externalCampaign: ").append(this.toIndentedString(this.externalCampaign)).append("\n");
        sb.append("    skipEnabled: ").append(this.toIndentedString(this.skipEnabled)).append("\n");
        sb.append("    timeoutSeconds: ").append(this.toIndentedString(this.timeoutSeconds)).append("\n");
        sb.append("    automatedCallbackConfigId: ").append(this.toIndentedString(this.automatedCallbackConfigId)).append("\n");
        sb.append("    callbackScheduledTime: ").append(this.toIndentedString(this.callbackScheduledTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALERTING("alerting"),
        DIALING("dialing"),
        CONTACTING("contacting"),
        OFFERING("offering"),
        CONNECTED("connected"),
        DISCONNECTED("disconnected"),
        TERMINATED("terminated"),
        CONVERTING("converting"),
        UPLOADING("uploading"),
        TRANSMITTING("transmitting"),
        PARKED("parked"),
        NONE("none");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DirectionEnumDeserializer.class)
    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DisconnectTypeEnumDeserializer.class)
    public static enum DisconnectTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ENDPOINT("endpoint"),
        ENDPOINT_DONOTDISTURB("endpoint.donotdisturb"),
        CLIENT("client"),
        SYSTEM("system"),
        TRANSFER("transfer"),
        TRANSFER_CONFERENCE("transfer.conference"),
        TRANSFER_CONSULT("transfer.consult"),
        TRANSFER_DONOTDISTURB("transfer.donotdisturb"),
        TRANSFER_FORWARD("transfer.forward"),
        TRANSFER_NOANSWER("transfer.noanswer"),
        TRANSFER_NOTAVAILABLE("transfer.notavailable"),
        TRANSPORT_FAILURE("transport.failure"),
        ERROR("error"),
        PEER("peer"),
        OTHER("other"),
        SPAM("spam");

        private String value;

        private DisconnectTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DisconnectTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DisconnectTypeEnum value : DisconnectTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DisconnectTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=FlaggedReasonEnumDeserializer.class)
    public static enum FlaggedReasonEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        GENERAL("general");

        private String value;

        private FlaggedReasonEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FlaggedReasonEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FlaggedReasonEnum value : FlaggedReasonEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FlaggedReasonEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FlaggedReasonEnumDeserializer
    extends StdDeserializer<FlaggedReasonEnum> {
        public FlaggedReasonEnumDeserializer() {
            super(FlaggedReasonEnumDeserializer.class);
        }

        public FlaggedReasonEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FlaggedReasonEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class DisconnectTypeEnumDeserializer
    extends StdDeserializer<DisconnectTypeEnum> {
        public DisconnectTypeEnumDeserializer() {
            super(DisconnectTypeEnumDeserializer.class);
        }

        public DisconnectTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DisconnectTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class DirectionEnumDeserializer
    extends StdDeserializer<DirectionEnum> {
        public DirectionEnumDeserializer() {
            super(DirectionEnumDeserializer.class);
        }

        public DirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

