/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ApiUsageSimpleSearch
implements Serializable {
    private String interval = null;
    private List<MetricsEnum> metrics = new ArrayList<MetricsEnum>();
    private List<String> oauthClientNames = new ArrayList<String>();
    private List<HttpMethodsEnum> httpMethods = new ArrayList<HttpMethodsEnum>();
    private List<String> templateUris = new ArrayList<String>();

    public ApiUsageSimpleSearch interval(String interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Behaves like one clause in a SQL WHERE. Specifies the date and time range of data being queried. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public ApiUsageSimpleSearch metrics(List<MetricsEnum> metrics) {
        this.metrics = metrics;
        return this;
    }

    @ApiModelProperty(example="null", value="Behaves like a SQL SELECT clause. Enables retrieving only named metrics. If omitted, all metrics that are available will be returned (like SELECT *).")
    @JsonProperty(value="metrics")
    public List<MetricsEnum> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<MetricsEnum> metrics) {
        this.metrics = metrics;
    }

    public ApiUsageSimpleSearch oauthClientNames(List<String> oauthClientNames) {
        this.oauthClientNames = oauthClientNames;
        return this;
    }

    @ApiModelProperty(example="null", value="Behaves like a SQL WHERE with multiple IN operators. Specifies a list of OAuth client names to be queried.")
    @JsonProperty(value="oauthClientNames")
    public List<String> getOauthClientNames() {
        return this.oauthClientNames;
    }

    public void setOauthClientNames(List<String> oauthClientNames) {
        this.oauthClientNames = oauthClientNames;
    }

    public ApiUsageSimpleSearch httpMethods(List<HttpMethodsEnum> httpMethods) {
        this.httpMethods = httpMethods;
        return this;
    }

    @ApiModelProperty(example="null", value="Behaves like a SQL WHERE with multiple IN operators. Specifies a list of HTTP methods to be queried.")
    @JsonProperty(value="httpMethods")
    public List<HttpMethodsEnum> getHttpMethods() {
        return this.httpMethods;
    }

    public void setHttpMethods(List<HttpMethodsEnum> httpMethods) {
        this.httpMethods = httpMethods;
    }

    public ApiUsageSimpleSearch templateUris(List<String> templateUris) {
        this.templateUris = templateUris;
        return this;
    }

    @ApiModelProperty(example="null", value="Behaves like a SQL WHERE with multiple IN operators. Specifies a list of Template Uris to be queried.")
    @JsonProperty(value="templateUris")
    public List<String> getTemplateUris() {
        return this.templateUris;
    }

    public void setTemplateUris(List<String> templateUris) {
        this.templateUris = templateUris;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiUsageSimpleSearch apiUsageSimpleSearch = (ApiUsageSimpleSearch)o;
        return Objects.equals(this.interval, apiUsageSimpleSearch.interval) && Objects.equals(this.metrics, apiUsageSimpleSearch.metrics) && Objects.equals(this.oauthClientNames, apiUsageSimpleSearch.oauthClientNames) && Objects.equals(this.httpMethods, apiUsageSimpleSearch.httpMethods) && Objects.equals(this.templateUris, apiUsageSimpleSearch.templateUris);
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.metrics, this.oauthClientNames, this.httpMethods, this.templateUris);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiUsageSimpleSearch {\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    oauthClientNames: ").append(this.toIndentedString(this.oauthClientNames)).append("\n");
        sb.append("    httpMethods: ").append(this.toIndentedString(this.httpMethods)).append("\n");
        sb.append("    templateUris: ").append(this.toIndentedString(this.templateUris)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=HttpMethodsEnumDeserializer.class)
    public static enum HttpMethodsEnum {
        GET("GET"),
        POST("POST"),
        DELETE("DELETE"),
        PATCH("PATCH"),
        PUT("PUT"),
        HEAD("HEAD"),
        CONNECT("CONNECT"),
        OPTIONS("OPTIONS"),
        TRACE("TRACE");

        private String value;

        private HttpMethodsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static HttpMethodsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (HttpMethodsEnum value : HttpMethodsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return HttpMethodsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class HttpMethodsEnumDeserializer
    extends StdDeserializer<HttpMethodsEnum> {
        public HttpMethodsEnumDeserializer() {
            super(HttpMethodsEnumDeserializer.class);
        }

        public HttpMethodsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return HttpMethodsEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=MetricsEnumDeserializer.class)
    public static enum MetricsEnum {
        DATE("Date"),
        CLIENTNAME("ClientName"),
        HTTPMETHOD("HttpMethod"),
        TEMPLATEURI("TemplateUri"),
        STATUS200("Status200"),
        STATUS300("Status300"),
        STATUS400("Status400"),
        STATUS500("Status500"),
        STATUS429("Status429");

        private String value;

        private MetricsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MetricsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MetricsEnum value : MetricsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MetricsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MetricsEnumDeserializer
    extends StdDeserializer<MetricsEnum> {
        public MetricsEnumDeserializer() {
            super(MetricsEnumDeserializer.class);
        }

        public MetricsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MetricsEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

