/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.KnowledgeGuestDocumentCopy;
import java.util.HashMap;
import java.util.Map;

public class PostKnowledgeGuestSessionDocumentCopiesRequest {
    private String sessionId;
    private String documentId;
    private KnowledgeGuestDocumentCopy body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public PostKnowledgeGuestSessionDocumentCopiesRequest withSessionId(String sessionId) {
        this.setSessionId(sessionId);
        return this;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public PostKnowledgeGuestSessionDocumentCopiesRequest withDocumentId(String documentId) {
        this.setDocumentId(documentId);
        return this;
    }

    public KnowledgeGuestDocumentCopy getBody() {
        return this.body;
    }

    public void setBody(KnowledgeGuestDocumentCopy body) {
        this.body = body;
    }

    public PostKnowledgeGuestSessionDocumentCopiesRequest withBody(KnowledgeGuestDocumentCopy body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostKnowledgeGuestSessionDocumentCopiesRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<KnowledgeGuestDocumentCopy> withHttpInfo() {
        if (this.sessionId == null) {
            throw new IllegalStateException("Missing the required parameter 'sessionId' when building request for PostKnowledgeGuestSessionDocumentCopiesRequest.");
        }
        if (this.documentId == null) {
            throw new IllegalStateException("Missing the required parameter 'documentId' when building request for PostKnowledgeGuestSessionDocumentCopiesRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/knowledge/guest/sessions/{sessionId}/documents/{documentId}/copies").withPathParameter("sessionId", this.sessionId).withPathParameter("documentId", this.documentId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames(new String[0]).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String sessionId, String documentId) {
        return new Builder().withRequiredParams(sessionId, documentId);
    }

    public static class Builder {
        private final PostKnowledgeGuestSessionDocumentCopiesRequest request = new PostKnowledgeGuestSessionDocumentCopiesRequest();

        private Builder() {
        }

        public Builder withSessionId(String sessionId) {
            this.request.setSessionId(sessionId);
            return this;
        }

        public Builder withDocumentId(String documentId) {
            this.request.setDocumentId(documentId);
            return this;
        }

        public Builder withBody(KnowledgeGuestDocumentCopy body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String sessionId, String documentId) {
            this.request.setSessionId(sessionId);
            this.request.setDocumentId(documentId);
            return this;
        }

        public PostKnowledgeGuestSessionDocumentCopiesRequest build() {
            if (this.request.sessionId == null) {
                throw new IllegalStateException("Missing the required parameter 'sessionId' when building request for PostKnowledgeGuestSessionDocumentCopiesRequest.");
            }
            if (this.request.documentId == null) {
                throw new IllegalStateException("Missing the required parameter 'documentId' when building request for PostKnowledgeGuestSessionDocumentCopiesRequest.");
            }
            return this.request;
        }
    }
}

