/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetFlowsDatatableExportJobRequest {
    private String datatableId;
    private String exportJobId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getDatatableId() {
        return this.datatableId;
    }

    public void setDatatableId(String datatableId) {
        this.datatableId = datatableId;
    }

    public GetFlowsDatatableExportJobRequest withDatatableId(String datatableId) {
        this.setDatatableId(datatableId);
        return this;
    }

    public String getExportJobId() {
        return this.exportJobId;
    }

    public void setExportJobId(String exportJobId) {
        this.exportJobId = exportJobId;
    }

    public GetFlowsDatatableExportJobRequest withExportJobId(String exportJobId) {
        this.setExportJobId(exportJobId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetFlowsDatatableExportJobRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.datatableId == null) {
            throw new IllegalStateException("Missing the required parameter 'datatableId' when building request for GetFlowsDatatableExportJobRequest.");
        }
        if (this.exportJobId == null) {
            throw new IllegalStateException("Missing the required parameter 'exportJobId' when building request for GetFlowsDatatableExportJobRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/flows/datatables/{datatableId}/export/jobs/{exportJobId}").withPathParameter("datatableId", this.datatableId).withPathParameter("exportJobId", this.exportJobId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String datatableId, String exportJobId) {
        return new Builder().withRequiredParams(datatableId, exportJobId);
    }

    public static class Builder {
        private final GetFlowsDatatableExportJobRequest request = new GetFlowsDatatableExportJobRequest();

        private Builder() {
        }

        public Builder withDatatableId(String datatableId) {
            this.request.setDatatableId(datatableId);
            return this;
        }

        public Builder withExportJobId(String exportJobId) {
            this.request.setExportJobId(exportJobId);
            return this;
        }

        public Builder withRequiredParams(String datatableId, String exportJobId) {
            this.request.setDatatableId(datatableId);
            this.request.setExportJobId(exportJobId);
            return this;
        }

        public GetFlowsDatatableExportJobRequest build() {
            if (this.request.datatableId == null) {
                throw new IllegalStateException("Missing the required parameter 'datatableId' when building request for GetFlowsDatatableExportJobRequest.");
            }
            if (this.request.exportJobId == null) {
                throw new IllegalStateException("Missing the required parameter 'exportJobId' when building request for GetFlowsDatatableExportJobRequest.");
            }
            return this.request;
        }
    }
}

