/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetArchitectGrammarRequest {
    private String grammarId;
    private Boolean includeFileUrls;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getGrammarId() {
        return this.grammarId;
    }

    public void setGrammarId(String grammarId) {
        this.grammarId = grammarId;
    }

    public GetArchitectGrammarRequest withGrammarId(String grammarId) {
        this.setGrammarId(grammarId);
        return this;
    }

    public Boolean getIncludeFileUrls() {
        return this.includeFileUrls;
    }

    public void setIncludeFileUrls(Boolean includeFileUrls) {
        this.includeFileUrls = includeFileUrls;
    }

    public GetArchitectGrammarRequest withIncludeFileUrls(Boolean includeFileUrls) {
        this.setIncludeFileUrls(includeFileUrls);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetArchitectGrammarRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.grammarId == null) {
            throw new IllegalStateException("Missing the required parameter 'grammarId' when building request for GetArchitectGrammarRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/architect/grammars/{grammarId}").withPathParameter("grammarId", this.grammarId).withQueryParameters("includeFileUrls", "", this.includeFileUrls).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String grammarId) {
        return new Builder().withRequiredParams(grammarId);
    }

    public static class Builder {
        private final GetArchitectGrammarRequest request = new GetArchitectGrammarRequest();

        private Builder() {
        }

        public Builder withGrammarId(String grammarId) {
            this.request.setGrammarId(grammarId);
            return this;
        }

        public Builder withIncludeFileUrls(Boolean includeFileUrls) {
            this.request.setIncludeFileUrls(includeFileUrls);
            return this;
        }

        public Builder withRequiredParams(String grammarId) {
            this.request.setGrammarId(grammarId);
            return this;
        }

        public GetArchitectGrammarRequest build() {
            if (this.request.grammarId == null) {
                throw new IllegalStateException("Missing the required parameter 'grammarId' when building request for GetArchitectGrammarRequest.");
            }
            return this.request;
        }
    }
}

