/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class DeleteUserVerifierRequest {
    private String userId;
    private String verifierId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public DeleteUserVerifierRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public String getVerifierId() {
        return this.verifierId;
    }

    public void setVerifierId(String verifierId) {
        this.verifierId = verifierId;
    }

    public DeleteUserVerifierRequest withVerifierId(String verifierId) {
        this.setVerifierId(verifierId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public DeleteUserVerifierRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for DeleteUserVerifierRequest.");
        }
        if (this.verifierId == null) {
            throw new IllegalStateException("Missing the required parameter 'verifierId' when building request for DeleteUserVerifierRequest.");
        }
        return ApiRequestBuilder.create("DELETE", "/api/v2/users/{userId}/verifiers/{verifierId}").withPathParameter("userId", this.userId).withPathParameter("verifierId", this.verifierId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId, String verifierId) {
        return new Builder().withRequiredParams(userId, verifierId);
    }

    public static class Builder {
        private final DeleteUserVerifierRequest request = new DeleteUserVerifierRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withVerifierId(String verifierId) {
            this.request.setVerifierId(verifierId);
            return this;
        }

        public Builder withRequiredParams(String userId, String verifierId) {
            this.request.setUserId(userId);
            this.request.setVerifierId(verifierId);
            return this;
        }

        public DeleteUserVerifierRequest build() {
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for DeleteUserVerifierRequest.");
            }
            if (this.request.verifierId == null) {
                throw new IllegalStateException("Missing the required parameter 'verifierId' when building request for DeleteUserVerifierRequest.");
            }
            return this.request;
        }
    }
}

