/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetEmailsSettingsRequest;
import com.mypurecloud.sdk.v2.api.request.GetSettingsExecutiondataRequest;
import com.mypurecloud.sdk.v2.api.request.PatchEmailsSettingsRequest;
import com.mypurecloud.sdk.v2.api.request.PatchSettingsExecutiondataRequest;
import com.mypurecloud.sdk.v2.model.EmailSettings;
import com.mypurecloud.sdk.v2.model.ExecutionDataGlobalSettingsResponse;
import com.mypurecloud.sdk.v2.model.ExecutionDataSettingsRequest;
import java.io.IOException;

public class SettingsApi {
    private final ApiClient pcapiClient;

    public SettingsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SettingsApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public EmailSettings getEmailsSettings() throws IOException, ApiException {
        return this.getEmailsSettings(this.createGetEmailsSettingsRequest());
    }

    public ApiResponse<EmailSettings> getEmailsSettingsWithHttpInfo() throws IOException {
        return this.getEmailsSettings(this.createGetEmailsSettingsRequest().withHttpInfo());
    }

    private GetEmailsSettingsRequest createGetEmailsSettingsRequest() {
        return GetEmailsSettingsRequest.builder().build();
    }

    public EmailSettings getEmailsSettings(GetEmailsSettingsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<EmailSettings> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<EmailSettings>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<EmailSettings> getEmailsSettings(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<EmailSettings>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ExecutionDataGlobalSettingsResponse getSettingsExecutiondata() throws IOException, ApiException {
        return this.getSettingsExecutiondata(this.createGetSettingsExecutiondataRequest());
    }

    public ApiResponse<ExecutionDataGlobalSettingsResponse> getSettingsExecutiondataWithHttpInfo() throws IOException {
        return this.getSettingsExecutiondata(this.createGetSettingsExecutiondataRequest().withHttpInfo());
    }

    private GetSettingsExecutiondataRequest createGetSettingsExecutiondataRequest() {
        return GetSettingsExecutiondataRequest.builder().build();
    }

    public ExecutionDataGlobalSettingsResponse getSettingsExecutiondata(GetSettingsExecutiondataRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ExecutionDataGlobalSettingsResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ExecutionDataGlobalSettingsResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ExecutionDataGlobalSettingsResponse> getSettingsExecutiondata(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ExecutionDataGlobalSettingsResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public EmailSettings patchEmailsSettings(EmailSettings body) throws IOException, ApiException {
        return this.patchEmailsSettings(this.createPatchEmailsSettingsRequest(body));
    }

    public ApiResponse<EmailSettings> patchEmailsSettingsWithHttpInfo(EmailSettings body) throws IOException {
        return this.patchEmailsSettings(this.createPatchEmailsSettingsRequest(body).withHttpInfo());
    }

    private PatchEmailsSettingsRequest createPatchEmailsSettingsRequest(EmailSettings body) {
        return PatchEmailsSettingsRequest.builder().withBody(body).build();
    }

    public EmailSettings patchEmailsSettings(PatchEmailsSettingsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<EmailSettings> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<EmailSettings>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<EmailSettings> patchEmailsSettings(ApiRequest<EmailSettings> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<EmailSettings>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ExecutionDataGlobalSettingsResponse patchSettingsExecutiondata(ExecutionDataSettingsRequest body) throws IOException, ApiException {
        return this.patchSettingsExecutiondata(this.createPatchSettingsExecutiondataRequest(body));
    }

    public ApiResponse<ExecutionDataGlobalSettingsResponse> patchSettingsExecutiondataWithHttpInfo(ExecutionDataSettingsRequest body) throws IOException {
        return this.patchSettingsExecutiondata(this.createPatchSettingsExecutiondataRequest(body).withHttpInfo());
    }

    private PatchSettingsExecutiondataRequest createPatchSettingsExecutiondataRequest(ExecutionDataSettingsRequest body) {
        return PatchSettingsExecutiondataRequest.builder().withBody(body).build();
    }

    public ExecutionDataGlobalSettingsResponse patchSettingsExecutiondata(PatchSettingsExecutiondataRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ExecutionDataGlobalSettingsResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ExecutionDataGlobalSettingsResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ExecutionDataGlobalSettingsResponse> patchSettingsExecutiondata(ApiRequest<ExecutionDataSettingsRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ExecutionDataGlobalSettingsResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

