/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteOauthClientRequest;
import com.mypurecloud.sdk.v2.api.request.GetOauthAuthorizationRequest;
import com.mypurecloud.sdk.v2.api.request.GetOauthAuthorizationsRequest;
import com.mypurecloud.sdk.v2.api.request.GetOauthClientRequest;
import com.mypurecloud.sdk.v2.api.request.GetOauthClientUsageQueryResultRequest;
import com.mypurecloud.sdk.v2.api.request.GetOauthClientUsageSummaryRequest;
import com.mypurecloud.sdk.v2.api.request.GetOauthClientsRequest;
import com.mypurecloud.sdk.v2.api.request.GetOauthScopeRequest;
import com.mypurecloud.sdk.v2.api.request.GetOauthScopesRequest;
import com.mypurecloud.sdk.v2.api.request.PostOauthClientSecretRequest;
import com.mypurecloud.sdk.v2.api.request.PostOauthClientUsageQueryRequest;
import com.mypurecloud.sdk.v2.api.request.PostOauthClientsRequest;
import com.mypurecloud.sdk.v2.api.request.PutOauthClientRequest;
import com.mypurecloud.sdk.v2.model.ApiUsageClientQuery;
import com.mypurecloud.sdk.v2.model.ApiUsageQueryResult;
import com.mypurecloud.sdk.v2.model.OAuthAuthorization;
import com.mypurecloud.sdk.v2.model.OAuthAuthorizationListing;
import com.mypurecloud.sdk.v2.model.OAuthClient;
import com.mypurecloud.sdk.v2.model.OAuthClientEntityListing;
import com.mypurecloud.sdk.v2.model.OAuthClientRequest;
import com.mypurecloud.sdk.v2.model.OAuthScope;
import com.mypurecloud.sdk.v2.model.OAuthScopeListing;
import com.mypurecloud.sdk.v2.model.UsageExecutionResult;
import java.io.IOException;

public class OAuthApi {
    private final ApiClient pcapiClient;

    public OAuthApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OAuthApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteOauthClient(String clientId) throws IOException, ApiException {
        this.deleteOauthClient(this.createDeleteOauthClientRequest(clientId));
    }

    public ApiResponse<Void> deleteOauthClientWithHttpInfo(String clientId) throws IOException {
        return this.deleteOauthClient(this.createDeleteOauthClientRequest(clientId).withHttpInfo());
    }

    private DeleteOauthClientRequest createDeleteOauthClientRequest(String clientId) {
        return DeleteOauthClientRequest.builder().withClientId(clientId).build();
    }

    public void deleteOauthClient(DeleteOauthClientRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteOauthClient(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public OAuthAuthorization getOauthAuthorization(String clientId, String acceptLanguage) throws IOException, ApiException {
        return this.getOauthAuthorization(this.createGetOauthAuthorizationRequest(clientId, acceptLanguage));
    }

    public ApiResponse<OAuthAuthorization> getOauthAuthorizationWithHttpInfo(String clientId, String acceptLanguage) throws IOException {
        return this.getOauthAuthorization(this.createGetOauthAuthorizationRequest(clientId, acceptLanguage).withHttpInfo());
    }

    private GetOauthAuthorizationRequest createGetOauthAuthorizationRequest(String clientId, String acceptLanguage) {
        return GetOauthAuthorizationRequest.builder().withClientId(clientId).withAcceptLanguage(acceptLanguage).build();
    }

    public OAuthAuthorization getOauthAuthorization(GetOauthAuthorizationRequest request) throws IOException, ApiException {
        try {
            ApiResponse<OAuthAuthorization> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<OAuthAuthorization>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<OAuthAuthorization> getOauthAuthorization(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<OAuthAuthorization>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public OAuthAuthorizationListing getOauthAuthorizations(String acceptLanguage) throws IOException, ApiException {
        return this.getOauthAuthorizations(this.createGetOauthAuthorizationsRequest(acceptLanguage));
    }

    public ApiResponse<OAuthAuthorizationListing> getOauthAuthorizationsWithHttpInfo(String acceptLanguage) throws IOException {
        return this.getOauthAuthorizations(this.createGetOauthAuthorizationsRequest(acceptLanguage).withHttpInfo());
    }

    private GetOauthAuthorizationsRequest createGetOauthAuthorizationsRequest(String acceptLanguage) {
        return GetOauthAuthorizationsRequest.builder().withAcceptLanguage(acceptLanguage).build();
    }

    public OAuthAuthorizationListing getOauthAuthorizations(GetOauthAuthorizationsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<OAuthAuthorizationListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<OAuthAuthorizationListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<OAuthAuthorizationListing> getOauthAuthorizations(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<OAuthAuthorizationListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public OAuthClient getOauthClient(String clientId) throws IOException, ApiException {
        return this.getOauthClient(this.createGetOauthClientRequest(clientId));
    }

    public ApiResponse<OAuthClient> getOauthClientWithHttpInfo(String clientId) throws IOException {
        return this.getOauthClient(this.createGetOauthClientRequest(clientId).withHttpInfo());
    }

    private GetOauthClientRequest createGetOauthClientRequest(String clientId) {
        return GetOauthClientRequest.builder().withClientId(clientId).build();
    }

    public OAuthClient getOauthClient(GetOauthClientRequest request) throws IOException, ApiException {
        try {
            ApiResponse<OAuthClient> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<OAuthClient>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<OAuthClient> getOauthClient(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<OAuthClient>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ApiUsageQueryResult getOauthClientUsageQueryResult(String executionId, String clientId) throws IOException, ApiException {
        return this.getOauthClientUsageQueryResult(this.createGetOauthClientUsageQueryResultRequest(executionId, clientId));
    }

    public ApiResponse<ApiUsageQueryResult> getOauthClientUsageQueryResultWithHttpInfo(String executionId, String clientId) throws IOException {
        return this.getOauthClientUsageQueryResult(this.createGetOauthClientUsageQueryResultRequest(executionId, clientId).withHttpInfo());
    }

    private GetOauthClientUsageQueryResultRequest createGetOauthClientUsageQueryResultRequest(String executionId, String clientId) {
        return GetOauthClientUsageQueryResultRequest.builder().withExecutionId(executionId).withClientId(clientId).build();
    }

    public ApiUsageQueryResult getOauthClientUsageQueryResult(GetOauthClientUsageQueryResultRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ApiUsageQueryResult> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ApiUsageQueryResult>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ApiUsageQueryResult> getOauthClientUsageQueryResult(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ApiUsageQueryResult>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UsageExecutionResult getOauthClientUsageSummary(String clientId, String days) throws IOException, ApiException {
        return this.getOauthClientUsageSummary(this.createGetOauthClientUsageSummaryRequest(clientId, days));
    }

    public ApiResponse<UsageExecutionResult> getOauthClientUsageSummaryWithHttpInfo(String clientId, String days) throws IOException {
        return this.getOauthClientUsageSummary(this.createGetOauthClientUsageSummaryRequest(clientId, days).withHttpInfo());
    }

    private GetOauthClientUsageSummaryRequest createGetOauthClientUsageSummaryRequest(String clientId, String days) {
        return GetOauthClientUsageSummaryRequest.builder().withClientId(clientId).withDays(days).build();
    }

    public UsageExecutionResult getOauthClientUsageSummary(GetOauthClientUsageSummaryRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UsageExecutionResult> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UsageExecutionResult>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UsageExecutionResult> getOauthClientUsageSummary(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UsageExecutionResult>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public OAuthClientEntityListing getOauthClients() throws IOException, ApiException {
        return this.getOauthClients(this.createGetOauthClientsRequest());
    }

    public ApiResponse<OAuthClientEntityListing> getOauthClientsWithHttpInfo() throws IOException {
        return this.getOauthClients(this.createGetOauthClientsRequest().withHttpInfo());
    }

    private GetOauthClientsRequest createGetOauthClientsRequest() {
        return GetOauthClientsRequest.builder().build();
    }

    public OAuthClientEntityListing getOauthClients(GetOauthClientsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<OAuthClientEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<OAuthClientEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<OAuthClientEntityListing> getOauthClients(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<OAuthClientEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public OAuthScope getOauthScope(String scopeId, String acceptLanguage) throws IOException, ApiException {
        return this.getOauthScope(this.createGetOauthScopeRequest(scopeId, acceptLanguage));
    }

    public ApiResponse<OAuthScope> getOauthScopeWithHttpInfo(String scopeId, String acceptLanguage) throws IOException {
        return this.getOauthScope(this.createGetOauthScopeRequest(scopeId, acceptLanguage).withHttpInfo());
    }

    private GetOauthScopeRequest createGetOauthScopeRequest(String scopeId, String acceptLanguage) {
        return GetOauthScopeRequest.builder().withScopeId(scopeId).withAcceptLanguage(acceptLanguage).build();
    }

    public OAuthScope getOauthScope(GetOauthScopeRequest request) throws IOException, ApiException {
        try {
            ApiResponse<OAuthScope> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<OAuthScope>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<OAuthScope> getOauthScope(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<OAuthScope>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public OAuthScopeListing getOauthScopes(String acceptLanguage) throws IOException, ApiException {
        return this.getOauthScopes(this.createGetOauthScopesRequest(acceptLanguage));
    }

    public ApiResponse<OAuthScopeListing> getOauthScopesWithHttpInfo(String acceptLanguage) throws IOException {
        return this.getOauthScopes(this.createGetOauthScopesRequest(acceptLanguage).withHttpInfo());
    }

    private GetOauthScopesRequest createGetOauthScopesRequest(String acceptLanguage) {
        return GetOauthScopesRequest.builder().withAcceptLanguage(acceptLanguage).build();
    }

    public OAuthScopeListing getOauthScopes(GetOauthScopesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<OAuthScopeListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<OAuthScopeListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<OAuthScopeListing> getOauthScopes(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<OAuthScopeListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public OAuthClient postOauthClientSecret(String clientId) throws IOException, ApiException {
        return this.postOauthClientSecret(this.createPostOauthClientSecretRequest(clientId));
    }

    public ApiResponse<OAuthClient> postOauthClientSecretWithHttpInfo(String clientId) throws IOException {
        return this.postOauthClientSecret(this.createPostOauthClientSecretRequest(clientId).withHttpInfo());
    }

    private PostOauthClientSecretRequest createPostOauthClientSecretRequest(String clientId) {
        return PostOauthClientSecretRequest.builder().withClientId(clientId).build();
    }

    public OAuthClient postOauthClientSecret(PostOauthClientSecretRequest request) throws IOException, ApiException {
        try {
            ApiResponse<OAuthClient> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<OAuthClient>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<OAuthClient> postOauthClientSecret(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<OAuthClient>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UsageExecutionResult postOauthClientUsageQuery(String clientId, ApiUsageClientQuery body) throws IOException, ApiException {
        return this.postOauthClientUsageQuery(this.createPostOauthClientUsageQueryRequest(clientId, body));
    }

    public ApiResponse<UsageExecutionResult> postOauthClientUsageQueryWithHttpInfo(String clientId, ApiUsageClientQuery body) throws IOException {
        return this.postOauthClientUsageQuery(this.createPostOauthClientUsageQueryRequest(clientId, body).withHttpInfo());
    }

    private PostOauthClientUsageQueryRequest createPostOauthClientUsageQueryRequest(String clientId, ApiUsageClientQuery body) {
        return PostOauthClientUsageQueryRequest.builder().withClientId(clientId).withBody(body).build();
    }

    public UsageExecutionResult postOauthClientUsageQuery(PostOauthClientUsageQueryRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UsageExecutionResult> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UsageExecutionResult>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UsageExecutionResult> postOauthClientUsageQuery(ApiRequest<ApiUsageClientQuery> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UsageExecutionResult>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public OAuthClient postOauthClients(OAuthClientRequest body) throws IOException, ApiException {
        return this.postOauthClients(this.createPostOauthClientsRequest(body));
    }

    public ApiResponse<OAuthClient> postOauthClientsWithHttpInfo(OAuthClientRequest body) throws IOException {
        return this.postOauthClients(this.createPostOauthClientsRequest(body).withHttpInfo());
    }

    private PostOauthClientsRequest createPostOauthClientsRequest(OAuthClientRequest body) {
        return PostOauthClientsRequest.builder().withBody(body).build();
    }

    public OAuthClient postOauthClients(PostOauthClientsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<OAuthClient> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<OAuthClient>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<OAuthClient> postOauthClients(ApiRequest<OAuthClientRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<OAuthClient>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public OAuthClient putOauthClient(String clientId, OAuthClientRequest body) throws IOException, ApiException {
        return this.putOauthClient(this.createPutOauthClientRequest(clientId, body));
    }

    public ApiResponse<OAuthClient> putOauthClientWithHttpInfo(String clientId, OAuthClientRequest body) throws IOException {
        return this.putOauthClient(this.createPutOauthClientRequest(clientId, body).withHttpInfo());
    }

    private PutOauthClientRequest createPutOauthClientRequest(String clientId, OAuthClientRequest body) {
        return PutOauthClientRequest.builder().withClientId(clientId).withBody(body).build();
    }

    public OAuthClient putOauthClient(PutOauthClientRequest request) throws IOException, ApiException {
        try {
            ApiResponse<OAuthClient> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<OAuthClient>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<OAuthClient> putOauthClient(ApiRequest<OAuthClientRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<OAuthClient>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

